set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '4433400',
      147.867609,
      4,
      2,
      1,
      '401410',
      0.837469,
      NULL,
      31,
      NULL,
      0.880261,
      NULL,
      NULL,
      0.147922,
      1,
      NULL,
      0.634078,
      0,
      0,
      1.400349,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      6.357595,
      1.958759,
      0,
      1,
      3.703211,
      1.012467,
      7.912775,
      1,
      1.062839,
      3.054633,
      0,
      1,
      NULL,
      NULL,
      1.560678,
      NULL,
      NULL,
      2,
      1.993952,
      1,
      2.489016,
      NULL,
      1,
      NULL,
      2.645984,
      NULL,
      0.941430,
      1.018331,
      2.138662,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.142702,
      NULL,
      4.072571,
      0,
      1,
      NULL,
      1,
      NULL,
      2.035779,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723789,
      NULL,
      1.064579,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1.463720,
      0,
      2.531948,
      NULL,
      0.244585,
      NULL,
      1.070889,
      1,
      0.215035,
      0.173927,
      NULL,
      1,
      3.914036,
      2.891667,
      NULL,
      5,
      0,
      2.582703,
      NULL,
      5.213465,
      5,
      8,
      3,
      6,
      NULL,
      1.203140,
      7.308705,
      2.927391,
      NULL,
      NULL,
      0,
      6.439534,
      NULL,
      0,
      3,
      6,
      4,
      0,
      NULL,
      2,
      1.310418,
      0.495897,
      6.759467,
      0.498159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.454208,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637230,
      NULL,
      NULL,
      NULL,
      NULL,
      3.682715,
      2,
      2,
      1.293669,
      0,
      2.513534,
      2,
      3,
      0.509849,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      2.713877,
      1.697034,
      NULL,
      NULL,
      NULL,
      6.260419,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752018,
      NULL,
      NULL,
      1.423339,
      0.168929,
      3.666684,
      0,
      1,
      0.755525,
      2.929111,
      1.297734,
      NULL,
      0.163554,
      1,
      NULL,
      0,
      0,
      NULL,
      0.263704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


