set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '1231131',
      NULL,
      5,
      2.332114,
      2,
      '231314',
      1.389290,
      NULL,
      3,
      NULL,
      1,
      NULL,
      2.069541,
      NULL,
      NULL,
      NULL,
      0.452802,
      NULL,
      NULL,
      0.540913,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.001155,
      7,
      3,
      8,
      NULL,
      2.785570,
      0,
      3,
      3.145551,
      3,
      1.886883,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10.010629,
      0.186874,
      NULL,
      1,
      0.357740,
      0,
      1.287652,
      NULL,
      2.650616,
      1.906571,
      3.357909,
      3.582370,
      0.306859,
      0.458343,
      0.935442,
      0.406021,
      1.698915,
      0.908075,
      NULL,
      8,
      0,
      0,
      0,
      0,
      3.027948,
      NULL,
      NULL,
      NULL,
      1.883027,
      NULL,
      NULL,
      1,
      3.674771,
      NULL,
      NULL,
      5,
      6,
      0,
      2,
      2,
      0.869851,
      0,
      5.868389,
      0,
      4,
      1.469093,
      1,
      0,
      0,
      0.745541,
      NULL,
      NULL,
      7,
      0,
      1,
      0,
      1.457632,
      4,
      NULL,
      5,
      1,
      5,
      5.983299,
      6,
      1,
      1.394717,
      1,
      2.876520,
      NULL,
      9,
      7,
      NULL,
      0,
      4,
      7.710274,
      NULL,
      2,
      1,
      0,
      3.680136,
      0,
      NULL,
      1.762674,
      1.023136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877414,
      0.523015,
      NULL,
      1,
      0.830263,
      1,
      1,
      0.890177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137558,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      3.607267,
      0,
      1,
      3,
      6,
      3.152971,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.485030,
      0.854806,
      1,
      5,
      NULL,
      NULL,
      NULL,
      0,
      7.371416,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      0,
      0.927111,
      2,
      1.600725,
      3.379846,
      0.836718,
      1,
      1,
      NULL,
      0,
      1.611866,
      1.789765,
      1.363297,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '44334',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1.066653,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


