set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '111',
      '12',
      14.271430,
      11.677903,
      '1341221',
      NULL,
      0,
      NULL,
      2,
      '240421',
      2,
      ' 7-10-1994',
      30.545997,
      42.444505,
      1.867802,
      NULL,
      1.205337,
      3.051701,
      0,
      NULL,
      1,
      NULL,
      0,
      0.678729,
      1,
      1.233138,
      5.195342,
      NULL,
      0,
      NULL,
      1,
      1.553248,
      5.256106,
      NULL,
      2,
      0,
      3.215364,
      2.238286,
      NULL,
      1,
      NULL,
      1.143790,
      2,
      0,
      NULL,
      NULL,
      1.035070,
      NULL,
      NULL,
      0.014872,
      1,
      NULL,
      3,
      0,
      1.141444,
      0.512901,
      NULL,
      0.629955,
      2.474691,
      2.843426,
      1.558152,
      3,
      0.140216,
      0,
      0,
      NULL,
      2.715901,
      3,
      3.443177,
      4.946783,
      NULL,
      3,
      1,
      NULL,
      3.208855,
      0.443952,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      2.220773,
      3,
      0,
      NULL,
      NULL,
      0.614669,
      0,
      1,
      1.121157,
      0.581162,
      1.817584,
      0.612851,
      0,
      0,
      0.957606,
      NULL,
      0,
      4.995462,
      5.545281,
      0.260236,
      0,
      0.060379,
      0,
      0,
      0.042932,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      5,
      0,
      7.502106,
      1,
      3.225630,
      NULL,
      7.518129,
      NULL,
      NULL,
      0,
      2,
      4.388084,
      NULL,
      1,
      1.444567,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871775,
      NULL,
      NULL,
      1,
      NULL,
      0.802621,
      0,
      0.928099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.328411,
      1.785872,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.467678,
      3.067516,
      2.169182,
      2,
      1.861717,
      NULL,
      NULL,
      NULL,
      1,
      0.573884,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600682,
      3.092524,
      3,
      NULL,
      1.606406,
      3,
      2.032951,
      NULL,
      NULL,
      2,
      0.672058,
      1.922336,
      NULL,
      NULL,
      1.471402,
      1.230717,
      1.283733,
      NULL,
      0.180793,
      0.147513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.618464,
      '11144',
      '',
      '',
      1.432910,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      4.626008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


