set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      NULL,
      16,
      1.631836,
      '3231432',
      175.381151,
      1,
      2.100264,
      2,
      '444422',
      NULL,
      ' 2-26-2000',
      5,
      NULL,
      1.724332,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0.283662,
      1.017711,
      0,
      1,
      NULL,
      1,
      0.728683,
      1,
      0,
      0.359958,
      2,
      3.261899,
      7,
      7,
      NULL,
      2.686560,
      NULL,
      1,
      NULL,
      NULL,
      5.753232,
      0.541917,
      NULL,
      NULL,
      1.117544,
      NULL,
      NULL,
      NULL,
      1.383925,
      3,
      NULL,
      0,
      0.768514,
      1,
      1.644697,
      0.864944,
      3,
      NULL,
      0.803015,
      3,
      NULL,
      1.221615,
      1.043288,
      0.864895,
      3.231636,
      2.609060,
      1,
      3,
      0.823551,
      8.221397,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.590591,
      NULL,
      NULL,
      0.048771,
      4.136479,
      0.218698,
      NULL,
      0.064977,
      1.279291,
      4.887244,
      NULL,
      0.989663,
      1.990857,
      1,
      5,
      0,
      1.023644,
      0.116151,
      0,
      1.113234,
      1,
      1,
      NULL,
      1.776498,
      NULL,
      1,
      1,
      6.471834,
      1,
      2.782418,
      1,
      7.859128,
      1.962501,
      0.270189,
      1.084180,
      NULL,
      0.937108,
      NULL,
      NULL,
      2,
      7,
      4,
      NULL,
      3.987530,
      NULL,
      3,
      NULL,
      9.310192,
      3.749452,
      0.846089,
      3.113388,
      0.683657,
      1,
      0.451500,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.425242,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.262204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.804897,
      NULL,
      2.764279,
      NULL,
      0,
      NULL,
      1.804730,
      NULL,
      0,
      0.152554,
      1.494173,
      9.315010,
      3.905468,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0.608186,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745275,
      1,
      1.118037,
      2,
      NULL,
      2,
      0.167860,
      3.771725,
      2,
      NULL,
      NULL,
      0.725500,
      NULL,
      1,
      1.966834,
      NULL,
      NULL,
      0.218489,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '00404',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.032869,
      '',
      '',
      '',
      3.498508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


