set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      NULL,
      1,
      12,
      '2202302',
      32.989954,
      3,
      NULL,
      NULL,
      '103024',
      4.551266,
      ' 0- 4-1999',
      25,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      1.803061,
      0,
      3,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      1.074540,
      1.278658,
      1.210627,
      0.708346,
      5.876563,
      0,
      NULL,
      3,
      4.270288,
      2.427731,
      3,
      2,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.665394,
      0,
      2,
      NULL,
      0,
      2,
      2,
      1,
      2.793722,
      2.299307,
      1.522020,
      1,
      1,
      1,
      2.981263,
      1.749283,
      1.381996,
      2.936178,
      2.657911,
      3.848273,
      1.113228,
      2.302440,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.154682,
      7.481866,
      1,
      0.743013,
      NULL,
      1,
      1.004049,
      1.986500,
      0.572725,
      0.710046,
      1.274252,
      1,
      NULL,
      NULL,
      1.312129,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.331975,
      NULL,
      0.731456,
      NULL,
      2,
      0,
      NULL,
      1.473824,
      5.167309,
      2.058658,
      4,
      1,
      6,
      6.584284,
      3,
      NULL,
      5.958819,
      1.263801,
      6,
      3.147163,
      1.992980,
      NULL,
      NULL,
      3,
      0.258712,
      2,
      NULL,
      0.242516,
      NULL,
      1.231764,
      0.957306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667316,
      1.801492,
      1,
      NULL,
      1.086051,
      1.593244,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8.441892,
      3,
      1.105392,
      0.940276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.809940,
      NULL,
      NULL,
      NULL,
      1.100878,
      1,
      1,
      3.950097,
      3.823997,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      2.005353,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3.014182,
      3,
      1.121467,
      NULL,
      NULL,
      1.092816,
      NULL,
      1.629231,
      1.052009,
      0.980504,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.292328,
      '03222',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.551053,
      NULL,
      '',
      '',
      1.076161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


