set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43',
      32.956089,
      25,
      '0402340',
      31.117420,
      3,
      NULL,
      3,
      '134010',
      1.472446,
      NULL,
      34,
      18,
      0,
      NULL,
      0,
      3,
      1.484076,
      1.159389,
      1,
      NULL,
      0,
      NULL,
      3.953480,
      1,
      NULL,
      0,
      1.419779,
      2,
      0,
      4.461596,
      9,
      3,
      1,
      2.155453,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.618025,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.461393,
      6,
      0,
      2,
      0,
      0,
      1,
      1.879095,
      1.890371,
      2,
      NULL,
      1.453185,
      NULL,
      NULL,
      1,
      0.230542,
      0.668763,
      1,
      1.865042,
      2.450156,
      1,
      1.396594,
      0,
      0,
      NULL,
      1.695368,
      0.045708,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.118886,
      4.110792,
      1,
      2.987514,
      5,
      NULL,
      1.579297,
      0,
      NULL,
      0,
      1.236858,
      0.414094,
      NULL,
      2,
      NULL,
      0.183837,
      1.747123,
      0,
      1.113109,
      NULL,
      1,
      4.857574,
      4.198569,
      NULL,
      3.620372,
      0.148356,
      0.130647,
      0.041802,
      1,
      0.661162,
      6.251640,
      5,
      NULL,
      1,
      3,
      0,
      2,
      8,
      3.885086,
      3.397315,
      NULL,
      4,
      NULL,
      0.343867,
      0.295464,
      NULL,
      2,
      4,
      2,
      NULL,
      0.913568,
      7.846504,
      0.999301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1.782044,
      NULL,
      1.093707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.894234,
      NULL,
      1.921120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415760,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.551335,
      1,
      7,
      6,
      3,
      2,
      1.394670,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.588807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.997007,
      2,
      1.726913,
      3.681645,
      2,
      0,
      0.276077,
      NULL,
      0.134875,
      3.963799,
      3.288500,
      1.964960,
      NULL,
      0,
      1,
      0,
      NULL,
      1.680968,
      1.036712,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '22242',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.736718,
      '',
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


