set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '124',
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      3,
      0.879057,
      2,
      '223332',
      1,
      ' 0- 2-1979',
      27,
      NULL,
      1.461612,
      NULL,
      0.524154,
      0.592343,
      NULL,
      0.087442,
      0,
      2.800399,
      NULL,
      1.429235,
      1.558803,
      0,
      0,
      1,
      1.362240,
      0,
      3.260241,
      1,
      6,
      3,
      NULL,
      2,
      2,
      NULL,
      10,
      0,
      0,
      4,
      1.121485,
      0.678794,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10,
      0,
      NULL,
      2.971821,
      1,
      0,
      3,
      1,
      0,
      NULL,
      3.152038,
      0.289845,
      2.722758,
      1,
      0.824385,
      3,
      3.778855,
      1.583204,
      3.771579,
      1,
      1.717460,
      0,
      2.753023,
      NULL,
      NULL,
      0.800065,
      1,
      NULL,
      NULL,
      1.045549,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.658409,
      NULL,
      4.710186,
      0.249423,
      1.046078,
      2.950908,
      0.155973,
      0,
      3,
      NULL,
      NULL,
      1.001860,
      0,
      1.288181,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.413901,
      0,
      NULL,
      1,
      4.762441,
      1.989807,
      7,
      4.004723,
      4.412954,
      NULL,
      NULL,
      1.592331,
      NULL,
      NULL,
      1,
      2.661396,
      6,
      7,
      7,
      6,
      5,
      6.099108,
      4.842811,
      7.237545,
      0,
      5.193897,
      1.666739,
      1,
      0,
      6,
      1.303439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.843484,
      0.129328,
      0.866010,
      1.724332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.013420,
      NULL,
      6,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292370,
      2.195182,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.578785,
      1.901009,
      1,
      1,
      1.655829,
      NULL,
      NULL,
      NULL,
      0.593145,
      5.800945,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805991,
      3.014648,
      3.575804,
      0.926177,
      2,
      3,
      NULL,
      1.743138,
      1,
      0.902472,
      0,
      1,
      NULL,
      1,
      0.235373,
      0.986327,
      1,
      NULL,
      0.964167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '41241',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2.512818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


