set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '344',
      NULL,
      13,
      25.284851,
      '4231210',
      148.472649,
      2,
      0.138087,
      1,
      '420420',
      0.277748,
      '11-23-1990',
      26,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1.417969,
      NULL,
      1.293462,
      0,
      5,
      1.655805,
      0,
      2,
      1.803455,
      3,
      11.421205,
      2.936606,
      1.020572,
      1.042941,
      5.903009,
      2.865138,
      10.445995,
      1,
      NULL,
      0,
      1.412200,
      0.307500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.599466,
      1.132930,
      1,
      0,
      1,
      0,
      3.958678,
      0.970903,
      0,
      0.949508,
      1.175331,
      0.286209,
      2.034515,
      0,
      0.723020,
      3,
      0.555821,
      1.747863,
      NULL,
      0,
      1,
      3.158017,
      0,
      NULL,
      NULL,
      0.367508,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2.485314,
      0.595711,
      0,
      0,
      3,
      NULL,
      1.835845,
      1.982343,
      NULL,
      2.629095,
      0.142711,
      0,
      1,
      1.147298,
      1,
      NULL,
      1.152810,
      NULL,
      0,
      2,
      2.381108,
      1.708066,
      NULL,
      0.257870,
      NULL,
      0,
      3.650606,
      0,
      2,
      4.663442,
      3,
      NULL,
      2,
      7,
      2,
      NULL,
      0.329743,
      1.031684,
      NULL,
      3,
      0.559820,
      3.668072,
      9,
      0,
      1.782657,
      NULL,
      0.744780,
      0.595163,
      1.543147,
      4.366058,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.390402,
      1.389188,
      NULL,
      1.842175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.141490,
      3.152703,
      0.331152,
      0.684426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.453778,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.936106,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.093753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.844873,
      1.154499,
      1,
      NULL,
      0,
      1,
      0,
      0.624734,
      0.147180,
      0.920032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '40023',
      '',
      '',
      0.594262,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


