set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '211',
      '11',
      27,
      27.013928,
      '4140414',
      237,
      1,
      0.990400,
      0,
      '404011',
      2,
      ' 0-25-1991',
      37.980754,
      9.975385,
      1.115333,
      NULL,
      0.085860,
      NULL,
      0.293553,
      0.857932,
      0,
      1.893663,
      1.613276,
      NULL,
      3.251637,
      0.024476,
      2.036650,
      0,
      0,
      3.934879,
      1,
      2,
      0.710492,
      2,
      1.951820,
      1.114801,
      1,
      1.708435,
      9,
      NULL,
      2,
      5.513503,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.440577,
      NULL,
      0,
      1,
      0.515112,
      0,
      3.848319,
      0,
      NULL,
      NULL,
      0.026561,
      3,
      NULL,
      0,
      NULL,
      2.666560,
      1,
      2.853546,
      NULL,
      10.939362,
      0.452298,
      4.808132,
      NULL,
      3,
      0,
      4.953956,
      1.079214,
      NULL,
      NULL,
      1.301882,
      NULL,
      NULL,
      0,
      4.465218,
      5,
      2,
      1,
      3,
      NULL,
      2,
      NULL,
      0.740513,
      1,
      NULL,
      1,
      NULL,
      0.014865,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.038851,
      3,
      3,
      2,
      2.740462,
      0,
      6,
      0,
      4,
      1.059822,
      5,
      6.499543,
      6,
      1,
      1.816720,
      7,
      3.555572,
      2.470406,
      3.933985,
      0.654918,
      4.112978,
      5,
      NULL,
      10,
      4.705348,
      2.443904,
      2.547148,
      4,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282005,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.383239,
      3.983339,
      2.074474,
      3,
      NULL,
      0.720191,
      1,
      0.566996,
      NULL,
      4.953919,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.397149,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934577,
      1,
      NULL,
      2,
      NULL,
      3,
      0,
      3.505204,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0.134732,
      1,
      NULL,
      1.704762,
      NULL,
      1.024984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.043539,
      '',
      NULL,
      NULL,
      NULL,
      1.212129,
      2.054385,
      0,
      NULL,
      0.548153,
      2.274221,
      2.072089,
      NULL);
commit;
end;
/


