set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23124331',
      43,
      48,
      '0310043',
      125,
      4,
      1,
      3,
      '424221',
      NULL,
      '11-22-1987',
      37,
      23.270910,
      0,
      NULL,
      3.083099,
      2,
      0,
      0,
      NULL,
      0,
      1.100208,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0.639212,
      4.354767,
      8,
      NULL,
      7,
      7,
      7.076829,
      1,
      1.824859,
      3,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      3.784934,
      9.222761,
      2.291672,
      NULL,
      0.850357,
      3.257978,
      0,
      1,
      0.053515,
      3,
      1.438428,
      2.454083,
      3,
      0.717125,
      2,
      0.459420,
      2,
      NULL,
      3.417715,
      3,
      NULL,
      NULL,
      0,
      0,
      1.440222,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.123892,
      0,
      4.756612,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786225,
      1.001962,
      0.820926,
      NULL,
      3,
      0,
      1,
      1,
      1.304501,
      0.920244,
      NULL,
      0,
      2,
      1,
      0.655800,
      1.767099,
      NULL,
      NULL,
      0.834132,
      4,
      NULL,
      2.938551,
      1.909101,
      NULL,
      NULL,
      4.938132,
      NULL,
      5.907501,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      0.538835,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      5,
      1.285207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.411047,
      0,
      1,
      0.311513,
      1,
      NULL,
      0.850204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6.808533,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.504731,
      3.035033,
      NULL,
      NULL,
      NULL,
      NULL,
      4.200020,
      1.226143,
      7.620063,
      4.656597,
      3.260921,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685753,
      6.483833,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909091,
      1.031425,
      3,
      3.735505,
      0,
      3.063703,
      1,
      1.243770,
      2,
      2.001915,
      1,
      1,
      1.027576,
      1,
      1,
      1,
      1.674559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '24321',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      3.844850,
      2.498867,
      NULL,
      3,
      3.036030,
      NULL,
      3,
      1.615958);
commit;
end;
/


