set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '123',
      '34202203',
      3,
      23.392537,
      '3142403',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638356,
      NULL,
      NULL,
      31.769593,
      0.986953,
      NULL,
      NULL,
      0.521574,
      0.551584,
      NULL,
      0,
      0.900827,
      1.334843,
      1,
      NULL,
      NULL,
      0.271006,
      0,
      0.281963,
      2.343290,
      2.564635,
      2.045354,
      8,
      1.256161,
      11,
      3,
      NULL,
      NULL,
      11,
      3,
      NULL,
      1,
      4,
      1.672153,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10.387090,
      0,
      NULL,
      1.800751,
      1,
      1.092623,
      0,
      2,
      0.719228,
      0,
      2.713239,
      1,
      NULL,
      0.310078,
      3.993875,
      3,
      NULL,
      3,
      NULL,
      2.924120,
      5.154134,
      NULL,
      NULL,
      3,
      1,
      0.469593,
      1.617911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.704985,
      NULL,
      5.622921,
      NULL,
      NULL,
      2,
      5.863720,
      0,
      0.961570,
      1,
      3.226575,
      NULL,
      2,
      1,
      1.465937,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.894730,
      6,
      5.513329,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5.644860,
      5.486194,
      4,
      7.765053,
      3,
      2.602937,
      6.054901,
      NULL,
      4,
      6,
      4.011461,
      7.411813,
      1.546791,
      10,
      10,
      2.041881,
      3.580281,
      0.891388,
      2,
      1.524325,
      1.581075,
      4.245124,
      0.942156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924728,
      1,
      NULL,
      NULL,
      0.853969,
      0.832012,
      1.067696,
      1.052051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      2.342612,
      1,
      0.719613,
      2,
      1.959116,
      0,
      1,
      3.261452,
      4,
      3.179303,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      7,
      0.706633,
      1.147798,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.094673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079375,
      2,
      1.783612,
      2,
      0,
      2,
      NULL,
      1,
      NULL,
      1,
      0.529540,
      0.184086,
      0.669712,
      0,
      1,
      0.008755,
      1.163539,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.715865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '34304',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0.420221,
      3.192121,
      0,
      1.327276,
      3.461250,
      2.964124,
      2.452453,
      0,
      3);
commit;
end;
/


