set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40001144',
      38,
      6,
      '3124002',
      103,
      5,
      3,
      3,
      '111033',
      NULL,
      NULL,
      20,
      48,
      0,
      NULL,
      1,
      2.681303,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.744516,
      0,
      1,
      NULL,
      0,
      1,
      3,
      2,
      1.126729,
      3.649634,
      1,
      7.160085,
      2.236670,
      1,
      3.692460,
      2.201536,
      2,
      4,
      NULL,
      2,
      0.675847,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11,
      6,
      NULL,
      3,
      1.764971,
      0.703153,
      2,
      0.960772,
      1,
      2,
      NULL,
      0.109434,
      3.850214,
      0.655799,
      0,
      3.130177,
      1,
      3,
      NULL,
      5.549927,
      1,
      1,
      5,
      0,
      NULL,
      5.203458,
      0.038194,
      NULL,
      NULL,
      0.557493,
      NULL,
      NULL,
      0.174311,
      NULL,
      6.437701,
      2.267546,
      3,
      5.087770,
      1.868067,
      0.359125,
      1,
      0.736813,
      1,
      1.450364,
      1,
      3.027245,
      1.497820,
      1,
      NULL,
      1.665553,
      0.799646,
      NULL,
      1,
      1.454804,
      NULL,
      7,
      5.138686,
      1,
      5.421808,
      0.264355,
      6,
      5.598584,
      2,
      NULL,
      6.290509,
      4.552218,
      7.490419,
      NULL,
      5.441208,
      2,
      10.114676,
      2,
      7,
      1.832111,
      1.157844,
      7.656785,
      NULL,
      3,
      5.386762,
      1,
      0.538100,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328130,
      0.353868,
      NULL,
      0,
      NULL,
      0.928747,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.765045,
      1.225092,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4.844814,
      5.288364,
      2,
      0,
      6.673433,
      NULL,
      NULL,
      NULL,
      1,
      0.952994,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906676,
      NULL,
      0.225057,
      1.029498,
      2,
      1.359009,
      NULL,
      NULL,
      2.356375,
      2.170716,
      1.067749,
      0,
      NULL,
      0.265573,
      1.992407,
      0,
      0,
      1.373759,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353289,
      '04330',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.558855,
      '',
      '',
      '',
      3,
      1.783428,
      NULL,
      3,
      0.765258,
      NULL,
      2.257739,
      0.777146,
      1);
commit;
end;
/


