set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '410',
      '14303404',
      NULL,
      4.599110,
      '4101132',
      NULL,
      1,
      0.620797,
      3,
      '020233',
      4.463246,
      '10- 1-1981',
      25,
      15.763595,
      NULL,
      NULL,
      NULL,
      3.786953,
      1,
      1.420676,
      1.267668,
      1.213350,
      1.007253,
      0.102492,
      3.328986,
      0.527023,
      NULL,
      0,
      1.070088,
      NULL,
      1.269108,
      1,
      2.494361,
      3,
      3,
      2.819439,
      7.203179,
      NULL,
      11.569084,
      NULL,
      NULL,
      4,
      5,
      0.187314,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      3.924858,
      1.049713,
      NULL,
      NULL,
      1.560347,
      NULL,
      1.154602,
      1.896743,
      0,
      0.070810,
      NULL,
      0,
      0.276205,
      1,
      0,
      1.747909,
      3.212428,
      1.054850,
      NULL,
      NULL,
      0,
      3,
      0,
      2,
      4.967237,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.885704,
      8.398837,
      NULL,
      2.165039,
      2,
      NULL,
      3,
      0.778895,
      5,
      NULL,
      1,
      1.760715,
      NULL,
      1,
      NULL,
      1.483240,
      0.994434,
      1.988847,
      1.079327,
      NULL,
      0.101826,
      5,
      1.529483,
      5.969539,
      5.549683,
      0,
      3,
      NULL,
      0,
      NULL,
      2,
      1,
      5.732009,
      NULL,
      4,
      7.336462,
      NULL,
      4,
      2.840861,
      7,
      8,
      2.195274,
      0,
      2.547979,
      7.210172,
      9.116693,
      6.134354,
      NULL,
      0.792816,
      NULL,
      0.042058,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0.112221,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8,
      1.019312,
      1.227187,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.865704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.135539,
      NULL,
      7,
      NULL,
      2,
      5.654400,
      NULL,
      NULL,
      NULL,
      1.436659,
      6.077585,
      0.682036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.839841,
      2,
      2.343215,
      1,
      3.899793,
      2,
      NULL,
      1.206224,
      3.064074,
      0,
      0,
      NULL,
      0.462893,
      1,
      1,
      0,
      1,
      0,
      1.437170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      '',
      0.187033,
      '',
      '',
      '',
      1.370006,
      '',
      '',
      '',
      2.221382,
      3.024881,
      2.504474,
      0,
      3,
      3.309155,
      2.357652,
      1,
      1);
commit;
end;
/


