set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '100',
      NULL,
      18.795655,
      21,
      '1340034',
      274,
      6,
      NULL,
      1,
      '211102',
      2,
      ' 7-29-1988',
      4,
      45.566359,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390950,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      2.627094,
      NULL,
      0.501869,
      1,
      3,
      0,
      11.897165,
      3.508935,
      5.010478,
      5,
      NULL,
      9.705195,
      8,
      1,
      5,
      3,
      1.107967,
      0,
      NULL,
      NULL,
      1.319068,
      NULL,
      NULL,
      10,
      1.361512,
      3.373789,
      3,
      0,
      0,
      1.501800,
      2,
      1,
      0.917036,
      0.541748,
      0,
      2,
      1.372618,
      NULL,
      1,
      NULL,
      2.101463,
      3.440865,
      2.253677,
      1,
      NULL,
      2.672182,
      1,
      0,
      3.431818,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      7,
      6,
      NULL,
      2.676873,
      2,
      5.587914,
      2,
      0.871679,
      1.518380,
      1,
      0.153956,
      1,
      1.202287,
      0,
      0.251107,
      NULL,
      1.554738,
      0.504491,
      NULL,
      NULL,
      4.535536,
      1,
      1.003474,
      3.209333,
      NULL,
      6,
      0,
      NULL,
      3.983092,
      6,
      0.023545,
      NULL,
      0.166757,
      5.131502,
      3.064062,
      3,
      9.284903,
      1.799528,
      5,
      8,
      NULL,
      2,
      10,
      9.978116,
      5,
      7,
      2.043107,
      3.160654,
      NULL,
      0.490089,
      6.516338,
      1.856928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094504,
      1,
      NULL,
      1,
      1.669402,
      0.137665,
      1.421114,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      6.368052,
      1.038443,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.415512,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      7.848838,
      3,
      1.519820,
      NULL,
      0.107689,
      NULL,
      NULL,
      NULL,
      1,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.703179,
      1.850559,
      1,
      3,
      NULL,
      2,
      NULL,
      2,
      0,
      1.900058,
      0.947244,
      NULL,
      0.982565,
      NULL,
      0.595674,
      1,
      NULL,
      NULL,
      1.842476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142828,
      '40112',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.666588,
      '',
      '',
      NULL,
      3.303420,
      1,
      NULL,
      3,
      0.291289,
      NULL,
      1.799610,
      1.107219,
      3);
commit;
end;
/


