set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '301',
      '30001410',
      NULL,
      12,
      NULL,
      105.238400,
      4,
      3.030410,
      1,
      '321401',
      2.913551,
      ' 5-15-1988',
      28,
      35.855935,
      NULL,
      NULL,
      0.137376,
      NULL,
      1.381921,
      1.247910,
      1,
      0.688669,
      1.466985,
      NULL,
      1.053952,
      NULL,
      1.239663,
      1.084815,
      1,
      0.064690,
      0,
      0,
      11.698180,
      3,
      10.043370,
      8.775799,
      0,
      NULL,
      6,
      1,
      2,
      0,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      3.337863,
      1.267656,
      1.074793,
      3,
      0,
      NULL,
      1,
      0.618699,
      0.135437,
      0.967689,
      1,
      0.093899,
      1.195187,
      1.414764,
      0.942820,
      NULL,
      2.513326,
      0.477142,
      3.448456,
      6.794918,
      NULL,
      NULL,
      4.884711,
      1.793744,
      NULL,
      NULL,
      1.987769,
      NULL,
      NULL,
      0.193301,
      2,
      0.336155,
      0.864787,
      4.069217,
      NULL,
      3.280133,
      0,
      4,
      NULL,
      0,
      0.402912,
      1.488215,
      5.326264,
      0.796467,
      0,
      1,
      1.612712,
      NULL,
      NULL,
      1,
      5,
      1.409930,
      0.221881,
      4,
      0.574245,
      6,
      NULL,
      1,
      1.580733,
      5.348899,
      1,
      3,
      0,
      5.478388,
      5,
      5.307543,
      NULL,
      1.464261,
      2.257004,
      0,
      5.894642,
      8.755785,
      9.462348,
      7,
      3,
      0.691742,
      1,
      2.002649,
      1,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.494021,
      1,
      0,
      1.185505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3.284662,
      NULL,
      4,
      1.112036,
      2.625960,
      1.635022,
      0,
      3.743472,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.577057,
      2.787614,
      1,
      NULL,
      NULL,
      1.195650,
      NULL,
      NULL,
      0,
      4.371289,
      1.266317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      1,
      NULL,
      2,
      NULL,
      NULL,
      2.128914,
      1.597750,
      2.029350,
      NULL,
      0.501938,
      0,
      1,
      1.371150,
      1,
      1,
      1.773540,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.137294,
      '44000',
      '',
      NULL,
      0.086573,
      NULL,
      '',
      '',
      1,
      '40034',
      '',
      '',
      3.187906,
      NULL,
      2.903407,
      NULL,
      1,
      3.835196,
      2.446619,
      NULL,
      1);
commit;
end;
/


