set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0403',
      '04010022',
      38,
      NULL,
      '3303303',
      201.204804,
      1,
      NULL,
      1,
      '244113',
      NULL,
      NULL,
      16.415088,
      0.653059,
      NULL,
      NULL,
      0,
      NULL,
      0.335156,
      1.351281,
      NULL,
      NULL,
      1.710399,
      0.104142,
      0,
      0.629842,
      3.370436,
      1,
      1,
      0,
      0.685574,
      6.049117,
      11,
      1.122889,
      0,
      0,
      5.611115,
      0,
      NULL,
      1,
      NULL,
      1.096216,
      4.571395,
      NULL,
      NULL,
      NULL,
      1.021601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.796812,
      1,
      0.996052,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.190103,
      1,
      NULL,
      1,
      1.175962,
      1,
      0.470862,
      1.230405,
      4,
      1,
      2,
      2.958660,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      4,
      NULL,
      1,
      5.587239,
      1.514613,
      3.172872,
      NULL,
      1,
      NULL,
      0.685084,
      3.855842,
      0.577908,
      NULL,
      1.797807,
      0.298333,
      1.939567,
      NULL,
      NULL,
      5,
      1.865585,
      1.985916,
      4.008139,
      0.160687,
      0,
      1,
      NULL,
      2.062799,
      5,
      6.074434,
      NULL,
      NULL,
      6,
      1,
      NULL,
      10.256003,
      10,
      6.262868,
      8.203847,
      7.826762,
      NULL,
      NULL,
      2,
      NULL,
      3,
      3,
      0,
      0,
      0.351397,
      4.279961,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978483,
      0.027747,
      1,
      NULL,
      0,
      NULL,
      0.311375,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.044334,
      NULL,
      8.933530,
      3.921509,
      3.587109,
      0.091656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.073562,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      NULL,
      1.346965,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7,
      0.025058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531112,
      0,
      2,
      0,
      1.956512,
      2,
      3,
      0.667546,
      0.477113,
      3,
      NULL,
      1,
      1.310369,
      NULL,
      1.030564,
      1,
      1,
      0.662915,
      0,
      0.373748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '11004',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      3,
      '11020',
      '',
      '',
      1.931791,
      0,
      0.214862,
      NULL,
      NULL,
      2,
      3.661468,
      2,
      0.506305);
commit;
end;
/


