set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1132',
      '04000334',
      63,
      79,
      NULL,
      NULL,
      2,
      2.089743,
      NULL,
      '040420',
      6.159734,
      ' 0-23-1996',
      36,
      30.884746,
      0,
      NULL,
      1.355464,
      2.909628,
      1.844106,
      0.882161,
      0.998272,
      0,
      NULL,
      0.186047,
      0.910667,
      1.869795,
      NULL,
      NULL,
      0.668660,
      0.368392,
      3.891991,
      0.853779,
      10,
      NULL,
      5.986661,
      NULL,
      0,
      3.583487,
      8.683515,
      3,
      NULL,
      2.566884,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      0,
      NULL,
      0.481223,
      0,
      2.302110,
      0,
      1.740020,
      2,
      NULL,
      NULL,
      0.674734,
      NULL,
      0,
      3,
      1,
      NULL,
      0.216091,
      3,
      NULL,
      1.867851,
      10.324465,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887117,
      NULL,
      NULL,
      3.789638,
      1.293479,
      0,
      2.461591,
      0.443233,
      3.885641,
      1.718808,
      1,
      3.425055,
      0.423799,
      2,
      1,
      0.927419,
      1.017300,
      0,
      1.132045,
      NULL,
      0,
      3.047265,
      0,
      3,
      1,
      1,
      6,
      1.684685,
      4,
      NULL,
      NULL,
      5,
      2.786909,
      1.964507,
      7.474638,
      1.785363,
      3,
      0.923564,
      1.267163,
      3.771728,
      NULL,
      NULL,
      3,
      NULL,
      8.040313,
      0,
      6.128013,
      4.672821,
      2,
      1.623203,
      0.634485,
      4.286148,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434773,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9.148437,
      NULL,
      2,
      1.444440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.009958,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.211017,
      2,
      3,
      1,
      4.094558,
      0.252795,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.472949,
      0.192469,
      NULL,
      2.392566,
      NULL,
      1.004388,
      1,
      3.957951,
      0.156051,
      NULL,
      NULL,
      1.048933,
      0.257334,
      1,
      0.816455,
      0.541059,
      0,
      1.525498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.491627,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3,
      NULL,
      '',
      '',
      NULL,
      NULL,
      0,
      0.535248,
      3.909588,
      2,
      1,
      3.031000,
      3.071694);
commit;
end;
/


