set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24212401',
      1.487797,
      82,
      NULL,
      356.909493,
      0,
      3.589328,
      3,
      '034403',
      NULL,
      ' 5- 9-1986',
      38.680697,
      8.124814,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.265238,
      NULL,
      NULL,
      0.306592,
      0,
      3,
      NULL,
      NULL,
      1.947322,
      NULL,
      0.653053,
      2,
      0.389736,
      9.629800,
      3.193608,
      5.126841,
      NULL,
      1,
      0.251818,
      9.029934,
      1,
      1,
      0,
      4.455646,
      0.422741,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      0,
      0,
      NULL,
      1,
      3.147694,
      1,
      1.858177,
      NULL,
      0.241078,
      2.549561,
      3.975045,
      NULL,
      NULL,
      NULL,
      NULL,
      0.710200,
      5,
      6.244111,
      2,
      1,
      4.956099,
      1.580829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.485272,
      3.146573,
      2,
      0,
      NULL,
      0,
      0.778426,
      NULL,
      1,
      NULL,
      5.896392,
      0,
      5.936381,
      0,
      NULL,
      0.632668,
      1,
      NULL,
      NULL,
      0,
      7,
      3,
      5,
      4.085485,
      1.413278,
      1.558010,
      1,
      0,
      1.638614,
      1.372023,
      NULL,
      NULL,
      1.759490,
      NULL,
      5,
      NULL,
      11.274760,
      5.162258,
      8,
      7,
      5,
      1,
      7.696769,
      4.737000,
      5.769818,
      5.962489,
      7.890174,
      NULL,
      1.701061,
      0,
      2.676560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.202807,
      NULL,
      1,
      1,
      NULL,
      1,
      0.914395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.451083,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.734797,
      0.607561,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      2,
      4.896422,
      1,
      NULL,
      NULL,
      0.547231,
      NULL,
      1.505767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.333370,
      0,
      1,
      3.590540,
      0,
      NULL,
      2,
      3,
      2,
      1,
      1,
      1.215556,
      NULL,
      1.994928,
      1,
      0.527197,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.518856,
      '03443',
      NULL,
      '',
      0.476903,
      '',
      NULL,
      '',
      3,
      '10043',
      '3013',
      NULL,
      0.099744,
      2.886606,
      0,
      1,
      NULL,
      3.971319,
      0,
      1,
      2);
commit;
end;
/


