set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4303',
      '34223320',
      NULL,
      51,
      '4024132',
      36,
      2,
      2.351922,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.472664,
      1.434653,
      NULL,
      0.126933,
      1.278492,
      0.020033,
      1,
      1,
      0,
      1.549145,
      0,
      2.040311,
      1.766573,
      NULL,
      0.550341,
      1,
      1.429580,
      5,
      NULL,
      1.336217,
      3.782242,
      NULL,
      3.470922,
      1.361600,
      5.150643,
      7.800843,
      1,
      4,
      2.769211,
      1,
      1.916814,
      NULL,
      NULL,
      1.453207,
      NULL,
      NULL,
      3,
      0.321652,
      0,
      NULL,
      1.766063,
      1.425777,
      2.853789,
      0,
      0,
      3.011300,
      3.686983,
      1,
      1,
      3.591161,
      0,
      NULL,
      0.232855,
      0.186492,
      1,
      2,
      NULL,
      1.521920,
      5,
      2,
      0,
      5,
      0.996435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.076115,
      5,
      4,
      NULL,
      3,
      1,
      5.603855,
      5.162809,
      0,
      0.106030,
      NULL,
      3,
      NULL,
      1,
      0.453379,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.417681,
      0,
      NULL,
      5.292222,
      NULL,
      1,
      2,
      1.079747,
      2,
      2,
      4.392328,
      0.055238,
      3.010972,
      2,
      3.197157,
      5,
      2,
      0,
      3.792083,
      NULL,
      9.488672,
      4.145404,
      7,
      NULL,
      11.493703,
      2.563827,
      0,
      4.169558,
      0,
      1,
      1.061071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338614,
      1.248964,
      0,
      0,
      1.040846,
      0.003495,
      0.945880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      9,
      2,
      2.869145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.374589,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.780188,
      6.713700,
      0.316876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.214410,
      0,
      0.517774,
      2.041768,
      2,
      NULL,
      0.269013,
      0.892208,
      3,
      3.402448,
      1.317476,
      1.757185,
      1.449177,
      1,
      0,
      NULL,
      1,
      NULL,
      1.170253,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '10310',
      '',
      '',
      1.983153,
      NULL,
      '',
      '',
      NULL,
      '34224',
      NULL,
      '',
      4,
      0,
      0.144239,
      0.183486,
      NULL,
      1,
      2,
      NULL,
      NULL);
commit;
end;
/


