set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      8.485558,
      4,
      '0200222',
      13.663169,
      2,
      NULL,
      0,
      '431032',
      5,
      ' 7-21-1999',
      40,
      36,
      0,
      NULL,
      0,
      0,
      0.134933,
      1.207460,
      1.566385,
      1,
      1.801105,
      1.143412,
      0,
      NULL,
      NULL,
      NULL,
      0.299899,
      1,
      1,
      NULL,
      5.765244,
      NULL,
      0.726156,
      0.981764,
      1.764307,
      0,
      1.611359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.806932,
      0,
      3,
      NULL,
      1,
      0.349609,
      0.509567,
      2,
      2.695897,
      3.636610,
      3.724353,
      0.092577,
      0.609270,
      1,
      2,
      0,
      NULL,
      NULL,
      1.113233,
      NULL,
      NULL,
      1.584863,
      2.952223,
      0,
      2,
      1.794107,
      1.741432,
      NULL,
      NULL,
      0.952125,
      NULL,
      NULL,
      0.505893,
      1,
      1.571473,
      1,
      0.773815,
      NULL,
      0.248331,
      0,
      0.242599,
      1,
      0.842443,
      0,
      1.521643,
      0.037867,
      0,
      0.544533,
      0.141285,
      NULL,
      1.423077,
      NULL,
      0.345795,
      1.151783,
      NULL,
      0,
      0.766631,
      1,
      NULL,
      0,
      2.078769,
      3.530754,
      0,
      0,
      1.881135,
      1,
      3.296421,
      0,
      2,
      NULL,
      7.166142,
      4.698282,
      5,
      NULL,
      5,
      5,
      0.900942,
      0.981601,
      0,
      0.677870,
      2.246078,
      NULL,
      0,
      NULL,
      1.251254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.131795,
      0,
      NULL,
      0.693965,
      NULL,
      0.296267,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      0.391852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.701698,
      2.124949,
      NULL,
      1.768963,
      1,
      0,
      1,
      NULL,
      NULL,
      1.665377,
      1.949592,
      1.586475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.819256,
      0,
      0,
      0.726718,
      0,
      1,
      1.297152,
      0.441576,
      3.438913,
      0.559384,
      1.318134,
      0.933326,
      0,
      0,
      1.927846,
      1,
      1,
      NULL,
      0.677904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188186,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.453556,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118516,
      1,
      0.048891,
      NULL,
      1,
      NULL,
      1.415354,
      0,
      2,
      '00023',
      '',
      NULL,
      0.619771,
      '',
      '',
      '',
      0.042598,
      NULL,
      '',
      '',
      2,
      2,
      0.481633,
      NULL,
      NULL,
      5,
      3.408234,
      2,
      1);
commit;
end;
/


