set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      '02034132',
      47,
      29,
      NULL,
      15,
      NULL,
      2,
      2,
      '040104',
      0.168128,
      ' 1-11-1974',
      13,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.959772,
      0.984688,
      1,
      0,
      1,
      NULL,
      0.785683,
      NULL,
      NULL,
      NULL,
      0.487885,
      0,
      0.006047,
      4,
      1.054564,
      0.809630,
      NULL,
      1.555934,
      0.721409,
      2.863926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614584,
      2,
      5.983280,
      2,
      1.405739,
      0.232748,
      NULL,
      1.330664,
      1.480646,
      3.894801,
      NULL,
      1.149633,
      2,
      1,
      NULL,
      1.557390,
      1.288048,
      0.468100,
      1.347335,
      1.492712,
      NULL,
      0.904231,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.325518,
      1,
      0,
      1,
      1.634913,
      1,
      0,
      NULL,
      0,
      0.236593,
      1,
      0,
      1.041474,
      0.542955,
      1.729426,
      0.209000,
      0,
      0,
      NULL,
      0.988664,
      0.256923,
      0,
      NULL,
      NULL,
      1.153808,
      NULL,
      1,
      0.704431,
      0,
      0,
      NULL,
      1,
      0.729589,
      3,
      0,
      0.304049,
      3.534311,
      2.441815,
      0,
      4.247978,
      NULL,
      0,
      0.516327,
      NULL,
      0,
      0.724172,
      1.769953,
      3,
      0,
      0.474943,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.840625,
      NULL,
      NULL,
      0.112163,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      0,
      1.320467,
      1.330022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.469711,
      0.455020,
      4,
      3.921597,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.407716,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.270941,
      0.274764,
      NULL,
      1,
      1,
      1.955036,
      1,
      1,
      0,
      0,
      1.477974,
      0.484363,
      0,
      NULL,
      1.169166,
      NULL,
      1.248046,
      NULL,
      0.244103,
      1.947281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931976,
      1.555542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627651,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.154226,
      0.958408,
      1,
      1.364043,
      '41104',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      0.654160,
      2.724742,
      5,
      2,
      3.423450,
      0,
      0,
      1.675196);
commit;
end;
/


