set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      52,
      NULL,
      NULL,
      0,
      2,
      2.575584,
      0,
      NULL,
      NULL,
      '10-11-1976',
      NULL,
      61,
      0,
      NULL,
      2.643047,
      3,
      1.392389,
      1,
      0.102155,
      1.539694,
      1.358904,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0.528520,
      0.295196,
      0.396508,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.921167,
      NULL,
      1.037910,
      1,
      1.403198,
      0,
      3,
      2,
      1.820734,
      NULL,
      0,
      NULL,
      1,
      2.225473,
      1,
      1,
      1,
      0.888782,
      1,
      2,
      0,
      1.791854,
      NULL,
      1,
      0.091784,
      1.962235,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.861326,
      1.983246,
      1,
      0.237063,
      NULL,
      0.457407,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.724365,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.862472,
      0,
      1,
      0,
      1.432208,
      NULL,
      0.823547,
      0.776412,
      1.648708,
      NULL,
      1,
      1.285881,
      1,
      4.390871,
      4,
      5.375405,
      3.720062,
      1,
      0,
      1.045322,
      NULL,
      7,
      1.063336,
      5.128825,
      3.354321,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.158337,
      NULL,
      1.003162,
      0.121436,
      NULL,
      1,
      0.517464,
      NULL,
      NULL,
      NULL,
      0.641596,
      3.270359,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.307025,
      0,
      0,
      1,
      0.056856,
      NULL,
      0.551527,
      2.520528,
      1,
      1,
      0,
      NULL,
      1.755544,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467332,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.974959,
      1,
      0,
      2,
      0,
      '22214',
      '',
      NULL,
      0.099317,
      NULL,
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0,
      0,
      2.604194,
      NULL,
      NULL,
      5.195294,
      0.669311,
      NULL,
      0.234347);
commit;
end;
/


