set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '03014430',
      1.561286,
      24,
      '0312332',
      3.490783,
      3,
      3.278260,
      0,
      '032310',
      2,
      ' 8-29-1975',
      3,
      12.600989,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      0.141380,
      0,
      NULL,
      0.126199,
      1.599361,
      NULL,
      NULL,
      0,
      1,
      0.899183,
      0,
      1.169739,
      0.325151,
      0,
      0,
      0,
      0,
      0,
      1.041502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.089449,
      2.381865,
      NULL,
      NULL,
      0,
      NULL,
      0.713126,
      2,
      NULL,
      0.254028,
      3,
      3.157198,
      NULL,
      1.258456,
      2,
      3.726384,
      NULL,
      1.364639,
      1,
      1.363022,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432146,
      NULL,
      NULL,
      0.895177,
      1.631149,
      1.173568,
      NULL,
      0,
      NULL,
      0.606846,
      0.812214,
      0.471236,
      1.738163,
      0,
      0,
      1.957498,
      0,
      1.927371,
      1.270465,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.034970,
      NULL,
      0.573408,
      NULL,
      1,
      0.757108,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920501,
      1.216700,
      1.115427,
      NULL,
      5.811509,
      1.750846,
      NULL,
      0.994703,
      3,
      4,
      5.589387,
      1,
      6.245082,
      0.129778,
      2.698777,
      1.396271,
      0,
      NULL,
      NULL,
      5.498053,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1.698962,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.524236,
      0.031232,
      4,
      0,
      0,
      1,
      0.595625,
      NULL,
      NULL,
      NULL,
      0.234313,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.634941,
      0.855935,
      0,
      0.789176,
      1,
      1.718662,
      0,
      0.285358,
      NULL,
      3.845527,
      NULL,
      0,
      0,
      0.679584,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '00322',
      NULL,
      '',
      1.450387,
      '',
      '',
      '',
      1.279127,
      NULL,
      '',
      '',
      4,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      0.354204,
      1);
commit;
end;
/


