set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '023',
      '20334111',
      28.172253,
      57,
      NULL,
      31,
      NULL,
      1.445887,
      NULL,
      '211122',
      6,
      ' 5-27-1990',
      50.414321,
      48,
      1,
      NULL,
      NULL,
      1.204718,
      NULL,
      0,
      1.544155,
      0,
      1,
      NULL,
      1,
      0,
      1.093359,
      0,
      1.030417,
      1,
      1.227002,
      1,
      1.948024,
      1.616654,
      NULL,
      NULL,
      0,
      1.901826,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1.289679,
      0,
      1,
      1,
      NULL,
      2.213140,
      0.555072,
      NULL,
      3,
      1.319058,
      1.109934,
      3,
      0.894054,
      0.439679,
      0,
      1,
      0.871621,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.505920,
      NULL,
      NULL,
      1,
      0.977920,
      1,
      NULL,
      0,
      1.478680,
      1,
      1,
      0,
      NULL,
      1,
      0.664505,
      0,
      1.978895,
      0,
      1,
      0.823087,
      0,
      0.164324,
      NULL,
      0.651291,
      NULL,
      0.401782,
      0,
      NULL,
      1.788874,
      0.199955,
      0.040486,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560793,
      NULL,
      3.516352,
      1,
      3,
      1.298683,
      5.328840,
      0,
      4.624258,
      1,
      NULL,
      1,
      0,
      NULL,
      5.860043,
      3,
      1.625540,
      NULL,
      NULL,
      3,
      0.462750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160960,
      NULL,
      1,
      1,
      1.292885,
      0.105645,
      0,
      0.763998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.534688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.833316,
      0.126355,
      7.049665,
      NULL,
      1.017322,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.937313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.892071,
      NULL,
      0.839035,
      1.717289,
      1.541785,
      NULL,
      NULL,
      1,
      2,
      1.910118,
      1,
      0.989346,
      0,
      0.805435,
      1.316664,
      1,
      0.529384,
      NULL,
      0.207473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '43404',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      0.354546,
      NULL,
      NULL,
      '',
      0.910495,
      NULL,
      2.702039,
      NULL,
      3,
      1.333334,
      1,
      3,
      0.471538);
commit;
end;
/


