set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2022',
      '31234442',
      27.757586,
      6.597008,
      '0322202',
      12,
      1,
      2.275246,
      1,
      '123240',
      3,
      NULL,
      44.303453,
      49.200759,
      0.004823,
      NULL,
      1,
      0,
      3.628368,
      1.761412,
      1,
      0,
      1.044169,
      1,
      2.900655,
      1,
      0.374238,
      0,
      1,
      0,
      1.082261,
      0.435019,
      1,
      1.204090,
      0,
      1.307771,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.612515,
      1.497157,
      0.695346,
      0.752213,
      0.437738,
      0.026086,
      1.175379,
      NULL,
      2,
      0,
      3,
      0.491018,
      0,
      NULL,
      3,
      1,
      1.942821,
      NULL,
      1.843225,
      0.081817,
      0.951224,
      NULL,
      NULL,
      1,
      2,
      0,
      1.011434,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.173015,
      0.922133,
      NULL,
      1.721336,
      0,
      0.974568,
      0.150625,
      0,
      0.001378,
      1.807125,
      NULL,
      0.699702,
      0,
      NULL,
      1,
      1,
      NULL,
      1.163358,
      0,
      NULL,
      0.451877,
      0.064727,
      0,
      0.363519,
      NULL,
      0.205722,
      2.475521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      0.942122,
      0.444619,
      5,
      NULL,
      NULL,
      NULL,
      5.092609,
      4,
      7,
      NULL,
      5,
      1.042382,
      NULL,
      NULL,
      NULL,
      6.048129,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.492554,
      0,
      1,
      0,
      1,
      1.111761,
      0.061598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801714,
      0.500837,
      0.710984,
      0.869466,
      0.976627,
      NULL,
      NULL,
      1.058275,
      1.832691,
      2,
      1,
      NULL,
      1.956487,
      0,
      1.656474,
      0.199524,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.552649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.371536,
      '40244',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.078437,
      2,
      NULL,
      2,
      1,
      4.106170,
      1,
      2,
      4.860070);
commit;
end;
/


