set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3330',
      NULL,
      41.133273,
      28.568901,
      '0331231',
      73.873127,
      4,
      1,
      0,
      NULL,
      3.221274,
      '10-16-1998',
      19,
      9.633462,
      0.686475,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.181591,
      0.186844,
      1.524396,
      0,
      0.032811,
      0.200623,
      1.255818,
      0,
      NULL,
      0,
      0,
      1.595212,
      0,
      0,
      1.182847,
      NULL,
      0.167625,
      1.843100,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.429157,
      1.803595,
      NULL,
      0.254613,
      3.658335,
      0,
      1,
      NULL,
      2,
      0.316488,
      0,
      2.190487,
      0,
      0,
      1,
      0.810797,
      0.124303,
      1.219710,
      1,
      2.731221,
      1,
      2,
      0.451446,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.248007,
      0.235565,
      1.063097,
      1,
      0,
      0.851267,
      1,
      0.645006,
      0.303598,
      1,
      1.836886,
      0.260869,
      0,
      0.943155,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0.331920,
      2.643097,
      0.496180,
      0.307571,
      NULL,
      1,
      1,
      1.629562,
      1.001324,
      NULL,
      0,
      0,
      1,
      0.004771,
      3.236293,
      1.478591,
      0,
      0.821475,
      NULL,
      5.143992,
      NULL,
      3.125828,
      3,
      NULL,
      7,
      NULL,
      NULL,
      2.713301,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.194631,
      0,
      1,
      NULL,
      NULL,
      0.909419,
      0.148948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.725715,
      NULL,
      1,
      0,
      1.489614,
      NULL,
      NULL,
      NULL,
      1,
      0.947548,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071229,
      0,
      0.888823,
      1.754714,
      0.962547,
      1,
      1.908318,
      1,
      1,
      3.356809,
      1,
      0,
      0.280509,
      1,
      1,
      1.029721,
      1.199811,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      '',
      1.119529,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      1.944059,
      3);
commit;
end;
/


