set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0003',
      '20100013',
      25.342492,
      19.311631,
      '3031120',
      116.707223,
      NULL,
      3.840146,
      NULL,
      '022113',
      NULL,
      ' 2- 2-2002',
      36.940036,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.499461,
      0.093673,
      1,
      0,
      0.083668,
      1.046369,
      0.565424,
      0.000972,
      1.060623,
      NULL,
      1,
      1,
      1.953328,
      0.886524,
      NULL,
      0,
      NULL,
      0.309052,
      1.493117,
      0.574075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.736004,
      1.110415,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      1,
      NULL,
      0.084164,
      1,
      0.550887,
      1,
      1.010077,
      1,
      1.234266,
      0.797742,
      0.464305,
      1.298757,
      0.970478,
      0,
      4.913331,
      0,
      2,
      0.949112,
      1.386443,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.504401,
      NULL,
      1.195853,
      0.824538,
      1,
      1,
      0.000836,
      0.707203,
      NULL,
      1.688584,
      1.005857,
      NULL,
      0.355734,
      0,
      1,
      1,
      1.223912,
      1,
      0.622880,
      NULL,
      1,
      1.503375,
      0,
      NULL,
      0.718541,
      1,
      0.277387,
      1.779098,
      0.324598,
      0,
      0.217088,
      0,
      NULL,
      1,
      1,
      NULL,
      1.552594,
      NULL,
      2,
      0.359621,
      4.877099,
      1.662225,
      NULL,
      NULL,
      7,
      2.088835,
      6,
      5,
      1.133712,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879218,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0.401164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.254375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.402492,
      1,
      4,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184216,
      0,
      0.896430,
      0.427720,
      0.786677,
      0,
      0,
      0.971430,
      1.160485,
      1.031753,
      1,
      1.230035,
      1.249109,
      NULL,
      NULL,
      NULL,
      1.332966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '02443',
      '',
      '',
      0.466526,
      '',
      '',
      '',
      1.267244,
      '',
      '',
      '',
      3,
      1.660221,
      2.348393,
      1,
      3.516320,
      0.532262,
      2,
      2.629855,
      2);
commit;
end;
/


