set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9825488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '34400430',
      33.907898,
      72.159343,
      '4223033',
      10.613871,
      NULL,
      2,
      0,
      '220302',
      4.663566,
      NULL,
      58.595011,
      174.357631,
      NULL,
      NULL,
      3.003186,
      1,
      3,
      1,
      0.201856,
      2.683022,
      0,
      0.320805,
      2.072406,
      1.096001,
      11.051801,
      1,
      1.603744,
      1,
      1.412925,
      7,
      7,
      6.797108,
      9.205532,
      2.977845,
      2.111747,
      2.152623,
      11,
      0,
      5,
      NULL,
      2,
      0.998862,
      NULL,
      NULL,
      1.571494,
      NULL,
      NULL,
      5.269930,
      1.331506,
      NULL,
      0.742927,
      NULL,
      1,
      NULL,
      1.736001,
      1,
      3.183487,
      1,
      1.706314,
      3,
      NULL,
      NULL,
      0,
      2.116141,
      3,
      3.055441,
      NULL,
      1.347430,
      4,
      11.544757,
      NULL,
      2,
      2,
      0.806499,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4.775485,
      9,
      1.958819,
      9,
      0,
      0,
      1.247734,
      1.194194,
      0.015339,
      0.775433,
      NULL,
      NULL,
      NULL,
      1.900817,
      0,
      0.443159,
      2,
      NULL,
      1,
      8.274843,
      1,
      NULL,
      1.614462,
      NULL,
      0.274089,
      NULL,
      NULL,
      3,
      1,
      5.591835,
      3.861258,
      1,
      1.886183,
      7.398079,
      1.055871,
      4,
      5.641303,
      0.297541,
      3,
      5,
      3.354241,
      NULL,
      9,
      6,
      2.400871,
      1.255791,
      2.758174,
      2.862666,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780717,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.736126,
      NULL,
      4.589649,
      2.653005,
      2.265383,
      0.766979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004600,
      1,
      6.810392,
      0,
      1.358597,
      0,
      0.789249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.084316,
      NULL,
      1,
      NULL,
      3,
      0.777578,
      0.936084,
      1.663524,
      1.314458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545529,
      1.421656,
      0,
      1.634054,
      0.726177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.969528,
      '01410',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '1424',
      '',
      '',
      0.337004,
      1,
      0,
      NULL,
      1.662213,
      1.504302,
      2.644175,
      NULL,
      3.203434);
commit;
end;
/


