set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9825488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '400',
      NULL,
      76,
      36.380470,
      NULL,
      NULL,
      4,
      0.748904,
      3,
      '040334',
      3,
      NULL,
      114.292564,
      162.833264,
      0,
      NULL,
      1,
      1,
      3.618607,
      1,
      0,
      1,
      1,
      0.959212,
      3.481533,
      NULL,
      5,
      1.287715,
      1,
      1.242613,
      1.521771,
      6,
      4.309525,
      8.649220,
      1,
      1.654198,
      3.553624,
      0.262817,
      NULL,
      0,
      2.180798,
      0.588079,
      0.737868,
      NULL,
      NULL,
      NULL,
      0.619871,
      NULL,
      NULL,
      4.470173,
      1,
      1.204433,
      2.818167,
      0,
      1,
      0,
      2.453117,
      1,
      3,
      1.903410,
      NULL,
      1,
      0.359376,
      NULL,
      3,
      3.796530,
      2.469681,
      0,
      1,
      1,
      1.894635,
      NULL,
      0,
      1,
      1.997541,
      1.570251,
      NULL,
      NULL,
      1.910625,
      NULL,
      NULL,
      0.013822,
      2,
      5,
      1,
      1.302553,
      5,
      1.626591,
      0,
      0.282988,
      NULL,
      3,
      0.186363,
      1.935237,
      6.731536,
      0.363615,
      0.571285,
      1.729811,
      3,
      1.046226,
      NULL,
      NULL,
      0.164648,
      NULL,
      NULL,
      1,
      4,
      3,
      0.807644,
      2.552996,
      NULL,
      1.475772,
      4,
      1,
      1.305839,
      1,
      0.979198,
      NULL,
      4,
      2,
      5.013210,
      5.831753,
      7,
      1,
      NULL,
      11.317943,
      0,
      0.044581,
      2.930896,
      3,
      NULL,
      0.137834,
      0.400088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436416,
      0,
      NULL,
      0,
      0,
      0.432402,
      0.476213,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965694,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6.415030,
      1.006595,
      4,
      1,
      0.050001,
      NULL,
      NULL,
      NULL,
      0,
      4.013465,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.121762,
      1,
      1.566334,
      0,
      0,
      NULL,
      0,
      2,
      2.287636,
      1.685202,
      1,
      1.312006,
      1,
      1,
      1.311114,
      0.245813,
      0,
      0.997606,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '43244',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      3,
      '0033',
      '',
      NULL,
      2,
      3.646490,
      1,
      2,
      0.159119,
      3,
      NULL,
      3.138729,
      1.498840);
commit;
end;
/


