set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9825488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      '02232432',
      76.556880,
      76,
      NULL,
      20.974415,
      3,
      0,
      2,
      '343330',
      3.434273,
      ' 0-10-1996',
      28.659335,
      NULL,
      0.299396,
      NULL,
      NULL,
      0.767370,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      1.606222,
      0,
      2.514295,
      0.234880,
      1,
      NULL,
      1,
      3,
      0,
      5.475738,
      7.506299,
      3,
      3,
      2,
      NULL,
      1,
      5,
      0.674367,
      1,
      1.237868,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2.858418,
      0.385564,
      2.990742,
      1,
      0.793944,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.502356,
      3,
      NULL,
      0.459878,
      2,
      6.744116,
      1.992718,
      5.636522,
      10,
      1,
      NULL,
      1,
      1.116479,
      NULL,
      NULL,
      0.841729,
      NULL,
      NULL,
      1,
      1.456234,
      3.066029,
      0,
      7,
      8,
      1.429142,
      1,
      0,
      0,
      4.773130,
      1.661997,
      1,
      0.235714,
      1,
      0.294846,
      0.375483,
      2,
      0.202465,
      1.388344,
      3.406122,
      0,
      0,
      0,
      1.497143,
      0.590155,
      0.661364,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      1.211230,
      8.933623,
      0.422901,
      2,
      6.382950,
      NULL,
      9,
      8.136725,
      9,
      7,
      NULL,
      1.899039,
      0,
      1,
      NULL,
      0.880908,
      0,
      0.544291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108885,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.035982,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.247790,
      1,
      NULL,
      NULL,
      0,
      2,
      1.943413,
      NULL,
      NULL,
      NULL,
      1.253641,
      5,
      0.191152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.899464,
      1,
      0,
      NULL,
      1,
      NULL,
      2.773123,
      NULL,
      NULL,
      1,
      1.314215,
      NULL,
      0.922559,
      1.058510,
      0.485336,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '21041',
      '',
      '',
      0.984149,
      '',
      '',
      '',
      2,
      '0423',
      '',
      '',
      NULL,
      3.708551,
      NULL,
      0.602631,
      2,
      0,
      3.712782,
      NULL,
      0);
commit;
end;
/


