set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9825488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30210102',
      46,
      NULL,
      '4131313',
      2.058812,
      6,
      0,
      2,
      '344424',
      NULL,
      ' 2-25-1990',
      27,
      168,
      0.283109,
      NULL,
      0,
      0.000521,
      3,
      0.692671,
      3.332718,
      1.914008,
      NULL,
      1,
      2,
      0.701076,
      5.832788,
      0,
      0,
      2.585259,
      NULL,
      7.716086,
      7.925133,
      2.717188,
      2.455468,
      4,
      4,
      4,
      3.818819,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043223,
      9.595013,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.789535,
      3.715835,
      2,
      1.114748,
      1.112874,
      2.680978,
      0.926595,
      2.820390,
      0.829271,
      1,
      1.232245,
      NULL,
      1.368710,
      1.663764,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433356,
      NULL,
      NULL,
      3.956114,
      2,
      7,
      0,
      NULL,
      2,
      6.110243,
      3,
      1.037107,
      0,
      NULL,
      NULL,
      1.022202,
      2.239712,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.040986,
      1,
      NULL,
      NULL,
      1.381140,
      6,
      0,
      1.038205,
      3,
      1.702878,
      1,
      7,
      NULL,
      1,
      9,
      1,
      4.360308,
      NULL,
      6.309010,
      4.835530,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      0,
      2.625586,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.771784,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.071953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615420,
      0,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.051141,
      NULL,
      1.232499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.482636,
      NULL,
      1,
      3,
      1.989740,
      NULL,
      0,
      2.574151,
      1,
      0.249463,
      3.931693,
      0,
      0,
      1.069975,
      0,
      0,
      0,
      0.956172,
      0,
      0.442600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '43013',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '',
      5,
      0.171490,
      NULL,
      0.162570,
      NULL,
      NULL,
      1.482782,
      3,
      NULL);
commit;
end;
/


