set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9825488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1320',
      '01144032',
      14.708039,
      22,
      '3032243',
      70,
      1,
      0.261540,
      1,
      '333202',
      2.563474,
      ' 8- 2-1974',
      23.534266,
      23.304242,
      1,
      NULL,
      4.985687,
      1.307678,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      4.423426,
      3,
      NULL,
      4.165138,
      0.112019,
      0.137606,
      NULL,
      1.452396,
      NULL,
      NULL,
      1,
      1,
      5,
      4.286716,
      1,
      NULL,
      NULL,
      0.248160,
      NULL,
      NULL,
      1,
      1,
      3.183880,
      3.006211,
      1,
      3.742416,
      3,
      1,
      1,
      3.916305,
      0.250439,
      0.068051,
      1,
      3,
      0.821382,
      2,
      NULL,
      NULL,
      NULL,
      9.792529,
      7.780414,
      8,
      0,
      0,
      1,
      0.978454,
      0.253690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.327684,
      NULL,
      1,
      6,
      7,
      4.789448,
      2,
      1,
      3,
      2,
      5.322675,
      1,
      5.993541,
      1,
      0,
      1.065804,
      0,
      1.090475,
      NULL,
      0.406438,
      0,
      0,
      0,
      0,
      NULL,
      0.601140,
      0,
      NULL,
      1,
      1.088656,
      0,
      5.034363,
      0.936708,
      5,
      NULL,
      4,
      7.960596,
      0,
      5.337932,
      1.533634,
      0,
      0,
      0.272470,
      3,
      7.800863,
      NULL,
      0,
      1.576398,
      NULL,
      NULL,
      0.606809,
      0.858835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505575,
      0,
      0,
      NULL,
      0.035432,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790569,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.494539,
      1,
      1.483064,
      0,
      2,
      1.320438,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.462950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.351336,
      3.218125,
      3.165006,
      3,
      0,
      0,
      2,
      3,
      0.177507,
      2,
      1,
      0,
      0,
      1.808941,
      1.093719,
      1,
      NULL,
      1.374210,
      0.267881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '13010',
      '',
      '',
      1,
      '',
      '',
      '',
      2.813948,
      '1140',
      '',
      '',
      4,
      NULL,
      NULL,
      3,
      3.003127,
      NULL,
      NULL,
      0,
      2);
commit;
end;
/


