set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9825488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01123004',
      46,
      5.390414,
      '2031133',
      47.327852,
      3,
      1.382480,
      1,
      NULL,
      0,
      ' 9- 4-1978',
      20,
      32.927096,
      0.502569,
      NULL,
      3,
      0,
      0.978985,
      0,
      1,
      0,
      0.394740,
      1.485850,
      1.416421,
      1,
      5,
      1,
      0,
      0.130108,
      1,
      NULL,
      1,
      1.730497,
      2.162973,
      0.686819,
      2,
      0,
      7,
      0,
      1.610164,
      5.643249,
      5.714602,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.886545,
      1.480591,
      1,
      2,
      NULL,
      NULL,
      1.457811,
      NULL,
      0,
      3,
      0,
      0,
      3,
      2.444100,
      NULL,
      1,
      3,
      0,
      NULL,
      8.774520,
      3,
      3.890810,
      3.254743,
      1,
      NULL,
      4.896216,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.980197,
      1,
      3,
      2,
      7,
      5.401191,
      0.888260,
      NULL,
      NULL,
      1.711405,
      NULL,
      5.085199,
      0,
      2.724024,
      NULL,
      0.532397,
      1,
      0,
      0.569384,
      NULL,
      0.997591,
      NULL,
      1.776351,
      0,
      0,
      0.197318,
      0.173856,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1.686032,
      NULL,
      6,
      3.577056,
      NULL,
      NULL,
      5.390286,
      NULL,
      2,
      6.193656,
      1.826025,
      NULL,
      1.599565,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.247442,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392867,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.701074,
      NULL,
      NULL,
      1.336566,
      0.403585,
      NULL,
      0.095758,
      NULL,
      NULL,
      NULL,
      0.100173,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      1,
      0,
      3,
      2.717992,
      NULL,
      1.731336,
      0.121661,
      0.841214,
      NULL,
      1,
      NULL,
      1,
      0.415025,
      0.553838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.440806,
      '33321',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2,
      '1114',
      '',
      '',
      5.835008,
      1.049215,
      1.924574,
      NULL,
      3.348747,
      2,
      1,
      NULL,
      0.006131);
commit;
end;
/


