set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '0403423',
      4,
      2,
      3.785266,
      NULL,
      '320004',
      NULL,
      ' 7-10-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      13.034453,
      0,
      NULL,
      1.431374,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.312368,
      3.421120,
      NULL,
      3,
      5,
      0.885604,
      0,
      NULL,
      1,
      1.555157,
      1.206917,
      3.421306,
      0,
      1.292401,
      0,
      2,
      NULL,
      1.021394,
      0.790894,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      1.923984,
      4,
      1,
      1.495792,
      0,
      3.430419,
      NULL,
      2.876470,
      1,
      3,
      1.969686,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0.249207,
      0.579977,
      NULL,
      0,
      4.498065,
      NULL,
      0,
      0.545780,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.556530,
      1,
      NULL,
      NULL,
      1.253938,
      0.010122,
      0,
      0.902538,
      NULL,
      2.585149,
      NULL,
      1.692853,
      0,
      0.840141,
      1.626482,
      1.751050,
      NULL,
      1.811813,
      0,
      NULL,
      NULL,
      2,
      4.679603,
      NULL,
      3,
      0,
      0,
      1.061963,
      3.738692,
      2,
      9.237332,
      6.693849,
      NULL,
      3,
      5.210927,
      1,
      1.538854,
      2,
      7,
      7,
      8,
      7.084380,
      11,
      7.816996,
      NULL,
      NULL,
      0.231830,
      1.568300,
      0.015219,
      0,
      NULL,
      0,
      1.963993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.111628,
      0,
      0,
      1,
      1.113312,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.956382,
      2.484675,
      NULL,
      7,
      1.211435,
      2.594593,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686764,
      5.053053,
      1,
      6.648659,
      2,
      0,
      5.402370,
      0.618288,
      NULL,
      NULL,
      NULL,
      4.937470,
      1.422757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.756898,
      2,
      3.143704,
      0.727419,
      0.679519,
      NULL,
      0.714356,
      NULL,
      1,
      3,
      2,
      NULL,
      1.825153,
      0,
      1.310113,
      1.029142,
      NULL,
      NULL,
      1,
      0.810794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933256,
      '21431',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.103218,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


