set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      2.720816,
      ' 2-25-1982',
      2,
      NULL,
      0.171911,
      NULL,
      13.488779,
      1.723346,
      2.892692,
      0,
      NULL,
      NULL,
      NULL,
      2.218978,
      1.630537,
      1.017144,
      2.381166,
      NULL,
      NULL,
      7.207241,
      0,
      0,
      NULL,
      0,
      0.675862,
      NULL,
      0,
      0.477037,
      0.187264,
      NULL,
      1.319627,
      NULL,
      NULL,
      1.903808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.560692,
      NULL,
      7,
      3,
      0,
      0.932345,
      0.491491,
      1,
      0,
      NULL,
      2,
      1,
      0,
      0.778947,
      0,
      1.914017,
      0,
      1.091807,
      1.261632,
      0,
      0.020503,
      1.121290,
      3.242924,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.922685,
      NULL,
      NULL,
      0,
      1,
      0.019390,
      0.131185,
      1.767759,
      3,
      NULL,
      0.532088,
      0,
      NULL,
      0,
      1.513084,
      0,
      2.837669,
      0,
      1,
      0.696382,
      NULL,
      1.438057,
      NULL,
      0,
      6.687238,
      2.834134,
      1,
      2.575646,
      0,
      9,
      1.904778,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      7.482425,
      4.627321,
      1,
      NULL,
      8.610560,
      0.045253,
      1.467318,
      3,
      0.831977,
      0,
      7.870340,
      6,
      2,
      2,
      2,
      2,
      NULL,
      0.164864,
      4.960214,
      0.248128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0.745121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3,
      3.328027,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.671080,
      4.119617,
      5.920151,
      2,
      NULL,
      1.862372,
      NULL,
      NULL,
      NULL,
      1,
      5.061779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013459,
      1,
      2.164820,
      2.228312,
      3.157867,
      0,
      2.316581,
      0.522824,
      NULL,
      1.482341,
      NULL,
      NULL,
      0,
      0.918269,
      1.940719,
      NULL,
      0,
      NULL,
      0.040709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      '',
      '',
      0.545782,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


