set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13',
      26,
      2.236470,
      '0122430',
      48.197187,
      6,
      2,
      NULL,
      '310412',
      NULL,
      '10-22-1982',
      1.723749,
      17,
      NULL,
      NULL,
      1.825782,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.811048,
      NULL,
      1,
      2,
      NULL,
      0,
      3,
      1.194090,
      0.339250,
      NULL,
      NULL,
      1,
      0,
      2.910213,
      0.668876,
      5,
      NULL,
      1,
      NULL,
      1,
      1.710418,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.565410,
      5,
      NULL,
      2.324889,
      0,
      1.749124,
      3.933196,
      NULL,
      1.611646,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.296685,
      0.731811,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223562,
      NULL,
      2.683758,
      NULL,
      NULL,
      2,
      1.537032,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.106113,
      0.784996,
      0.692369,
      0,
      NULL,
      NULL,
      2.003163,
      1.402446,
      NULL,
      NULL,
      0.714406,
      1,
      1,
      NULL,
      1.328221,
      1,
      NULL,
      1,
      0.315070,
      NULL,
      0,
      0,
      NULL,
      0,
      2.081690,
      1.207982,
      6,
      0.507173,
      1.118475,
      5.439924,
      3.827329,
      1,
      NULL,
      5.617941,
      0.017761,
      0,
      3,
      NULL,
      6.643702,
      7.152719,
      4,
      7.809615,
      7.943891,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5.497251,
      1.784448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.628277,
      0,
      1,
      0.344810,
      0.928674,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952968,
      NULL,
      7,
      1.672292,
      NULL,
      1.382958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.651671,
      7,
      5.184684,
      1.398800,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.065693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574081,
      0.646567,
      3.653259,
      0.102156,
      NULL,
      2,
      2,
      0.772540,
      0,
      3,
      1,
      0,
      0.347570,
      0.529877,
      1.366745,
      1.998472,
      NULL,
      1.304999,
      1.050253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '11333',
      NULL,
      '',
      0.366169,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


