set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      '02',
      16.096790,
      15.517306,
      NULL,
      6,
      3,
      2.419814,
      3,
      '130204',
      3,
      ' 8- 0-1974',
      4,
      NULL,
      1,
      NULL,
      0.583009,
      0.277346,
      1.855221,
      0,
      0.721353,
      NULL,
      1.725952,
      NULL,
      NULL,
      1.567288,
      3,
      1.996663,
      NULL,
      2,
      1,
      1,
      4,
      0,
      0.392017,
      1,
      NULL,
      NULL,
      1.301822,
      0,
      4,
      3,
      NULL,
      1.592672,
      NULL,
      NULL,
      1.647414,
      NULL,
      NULL,
      1.786390,
      5,
      1,
      1,
      NULL,
      0.672926,
      0,
      3,
      NULL,
      2.419508,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.664263,
      0,
      NULL,
      0,
      1,
      1.368719,
      NULL,
      4,
      NULL,
      1,
      1.096569,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.253789,
      0.187994,
      1,
      1,
      0.717734,
      0.984503,
      NULL,
      1.709893,
      0.883498,
      0.821685,
      NULL,
      1,
      1.110988,
      NULL,
      0.704846,
      1.257360,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.192725,
      2.372344,
      0.160070,
      2.034951,
      0.857169,
      1,
      2.075973,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      0,
      1,
      6,
      NULL,
      2.826861,
      NULL,
      NULL,
      NULL,
      0.251078,
      0,
      1,
      0.585178,
      NULL,
      NULL,
      7,
      0.278778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725431,
      1,
      1,
      NULL,
      1.595358,
      1,
      0,
      0.498061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617890,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.548443,
      1.132653,
      8,
      5.343674,
      1,
      0,
      1.953077,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581597,
      1,
      2.052091,
      1.737820,
      1,
      1,
      1,
      1.898864,
      NULL,
      1,
      3,
      1.371442,
      1,
      1.229767,
      NULL,
      1,
      1.063412,
      1,
      NULL,
      1.146515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


