set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      '23',
      NULL,
      9,
      '4131023',
      NULL,
      1,
      3.000634,
      3,
      '240101',
      2,
      ' 1-18-1982',
      47.975168,
      53.064546,
      1.722181,
      NULL,
      1.021663,
      1,
      2,
      1,
      1.724534,
      1.802760,
      1,
      0,
      0.677559,
      1.733179,
      5,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.749166,
      0.503979,
      2.576348,
      4,
      1,
      0,
      NULL,
      NULL,
      0.247893,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      0.765079,
      0.214522,
      1,
      NULL,
      0.267664,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      2.161686,
      1,
      1.275908,
      0,
      0,
      1,
      1.599440,
      2.576206,
      0,
      NULL,
      0.015752,
      NULL,
      NULL,
      NULL,
      1.043604,
      NULL,
      NULL,
      1.551965,
      1.081280,
      0,
      NULL,
      0,
      1.416688,
      0.838602,
      1,
      0.360522,
      1.698753,
      NULL,
      0.163639,
      NULL,
      2.426081,
      0.706701,
      0.740961,
      0,
      1.394716,
      0.672545,
      NULL,
      0.727516,
      NULL,
      2.565438,
      0.240236,
      3,
      0.281219,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769809,
      3.021481,
      3,
      1.455642,
      5.744319,
      6,
      7,
      0.132281,
      7,
      NULL,
      7,
      5,
      NULL,
      0.633839,
      0.162383,
      1.189264,
      NULL,
      NULL,
      NULL,
      5.072986,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.781899,
      0.037397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.241343,
      0,
      0.921740,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.814876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.511318,
      9.801158,
      1.136816,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.052207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476847,
      3.465366,
      0.547319,
      1,
      1.179662,
      0.361484,
      3,
      1,
      1,
      NULL,
      3.603598,
      NULL,
      0.833696,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.157667,
      '00231',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


