set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      '34',
      10.052327,
      11,
      '1324132',
      67.678409,
      NULL,
      NULL,
      0,
      '124043',
      1,
      ' 1-15-1997',
      82,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.367018,
      0.654457,
      0,
      1,
      0.416070,
      0,
      3,
      NULL,
      0,
      NULL,
      1.272438,
      1.070340,
      0.866456,
      NULL,
      0,
      0.803790,
      0.144507,
      0.328961,
      3,
      1,
      3,
      0.490202,
      NULL,
      0.159421,
      NULL,
      NULL,
      0.783600,
      NULL,
      NULL,
      5.351326,
      NULL,
      0.593115,
      0.633531,
      1.076590,
      0.593399,
      3.551705,
      3.132011,
      0,
      1,
      0.819158,
      NULL,
      1,
      0.943900,
      0.048214,
      NULL,
      1.123218,
      2.269439,
      1,
      0,
      NULL,
      0.816687,
      2,
      0,
      1,
      1,
      1.176241,
      NULL,
      NULL,
      1.508454,
      NULL,
      NULL,
      1,
      0.869002,
      4,
      NULL,
      1.722224,
      0,
      NULL,
      NULL,
      0,
      1.959682,
      0.561926,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1.504527,
      NULL,
      1.417444,
      NULL,
      1.591721,
      4.608549,
      NULL,
      4.101175,
      3.226451,
      1.468334,
      NULL,
      0,
      1,
      1.654075,
      NULL,
      0.929181,
      1.797374,
      NULL,
      5,
      NULL,
      1,
      7,
      0.932922,
      3,
      0.260415,
      1.377992,
      11.436414,
      2,
      8.573496,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516273,
      NULL,
      1,
      NULL,
      0,
      0.076971,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.336060,
      6.722277,
      1,
      1,
      NULL,
      0.880229,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.315189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      3,
      NULL,
      0,
      1.029650,
      0,
      NULL,
      1,
      NULL,
      0.818109,
      NULL,
      0,
      1,
      0,
      0.034784,
      1,
      0.479194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '13340',
      '',
      NULL,
      1.973759,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


