set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518819';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      31.131411,
      35.264879,
      '2132024',
      109.053570,
      2,
      NULL,
      0,
      '042142',
      0.523728,
      NULL,
      0.984047,
      44.198149,
      0.157270,
      NULL,
      2,
      0,
      0,
      1,
      1,
      1,
      1,
      1.797870,
      0,
      0.763830,
      0,
      0.519659,
      1.551823,
      1,
      NULL,
      1.416449,
      NULL,
      1.241688,
      1,
      NULL,
      1,
      0,
      0.995083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865113,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941320,
      2,
      3,
      0.951093,
      1.194042,
      1.978766,
      NULL,
      1,
      1.317550,
      NULL,
      NULL,
      1.749627,
      0.943631,
      1.650495,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.114564,
      1.034499,
      1,
      1,
      1,
      NULL,
      0.290033,
      0.486452,
      2,
      1.756390,
      0.625030,
      1.361667,
      NULL,
      0.347024,
      0.494399,
      1,
      3.748452,
      0,
      3.693594,
      5.052095,
      1,
      0,
      5.328242,
      1,
      NULL,
      1.089694,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.470656,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.353751,
      0,
      0,
      0,
      0,
      0,
      0.092228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382608,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523057,
      0.535145,
      1,
      2,
      1,
      2.700948,
      NULL,
      NULL,
      NULL,
      1.594942,
      0.793446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270777,
      0.420342,
      NULL,
      NULL,
      0,
      1,
      1.963319,
      NULL,
      1.165642,
      NULL,
      1.803194,
      0.834826,
      0.182144,
      0,
      0,
      NULL,
      NULL,
      0.798390,
      NULL,
      1.585128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088978,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.253445,
      NULL,
      NULL,
      0,
      0.957078,
      1.731081,
      2,
      2.746966,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      3.694862,
      5,
      0,
      NULL,
      0.525170,
      NULL,
      2.292797,
      NULL,
      1);
commit;
end;
/


