set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518819';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02040441',
      13.715774,
      37,
      NULL,
      37,
      3,
      2.820619,
      0,
      NULL,
      2,
      ' 4-11-2003',
      1,
      24.720764,
      0.338090,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0.078172,
      1.377531,
      0,
      0.133720,
      1,
      0,
      0.063164,
      0.924717,
      NULL,
      0,
      0,
      1,
      1,
      1.854532,
      1.168854,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.989832,
      0.674885,
      1,
      0.200108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740121,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414373,
      1.215581,
      5.595454,
      0,
      4,
      NULL,
      0.262034,
      0.512819,
      1,
      0.687757,
      0.913699,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0.674755,
      NULL,
      0.687732,
      0,
      0,
      NULL,
      0.785643,
      1.403113,
      0,
      NULL,
      1.104857,
      1.588260,
      0.772530,
      1.870040,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      7.930998,
      0,
      NULL,
      7.373378,
      3.244227,
      0,
      NULL,
      1,
      0.972289,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797678,
      1,
      0,
      0,
      0.435583,
      NULL,
      NULL,
      1.889495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2,
      1.553882,
      0.437941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.832689,
      2,
      1.736818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.528998,
      2,
      5,
      1,
      3.060266,
      0.847291,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.184951,
      0.149291,
      0,
      1.498794,
      NULL,
      0,
      1,
      NULL,
      3.221229,
      1,
      0,
      1.707669,
      1.373037,
      0.033253,
      0,
      0,
      0.178405,
      0.341568,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.459166,
      0.791346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363097,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.557584,
      1.966328,
      NULL,
      0,
      1.303773,
      1.589426,
      1,
      NULL,
      '14143',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.412619,
      NULL,
      '',
      '',
      0,
      2.759453,
      3.054517,
      5.816243,
      0,
      NULL,
      1.943599,
      1,
      2.487222);
commit;
end;
/


