set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9933372';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10201431',
      29.995524,
      64,
      '1134102',
      NULL,
      NULL,
      3.351528,
      NULL,
      '234203',
      NULL,
      ' 4- 6-1994',
      10.657346,
      47.826167,
      0.072319,
      NULL,
      12.256223,
      1.648793,
      0.766509,
      1.171558,
      0.404649,
      1.614153,
      0.325889,
      1,
      0.543962,
      1,
      9.994738,
      0,
      3.391034,
      1,
      NULL,
      6,
      7.430723,
      0.672084,
      6,
      1,
      2.940029,
      0.057250,
      7.140361,
      1,
      1.876807,
      4.844234,
      2.412358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.029348,
      2.103443,
      NULL,
      2.904342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187475,
      NULL,
      3.191877,
      6,
      3,
      1,
      4,
      0,
      NULL,
      NULL,
      1.073552,
      NULL,
      NULL,
      NULL,
      0.063588,
      2,
      NULL,
      4.098948,
      7.609111,
      4.733315,
      1.067270,
      0.463464,
      0,
      0,
      1,
      1.345037,
      NULL,
      0,
      0.950861,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      4,
      0.847687,
      7,
      NULL,
      3,
      3,
      3.663762,
      3,
      1.795735,
      7.979770,
      3,
      5.165748,
      0.567608,
      4,
      2.979332,
      5,
      2,
      0,
      8.702066,
      0,
      1.007294,
      6,
      NULL,
      7,
      1.505302,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      1.215954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.325325,
      1.172879,
      0.513985,
      0.720142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153834,
      1,
      1.622581,
      1.977427,
      0.521163,
      1.535554,
      NULL,
      0.274201,
      1.909609,
      NULL,
      5.389192,
      NULL,
      0.556458,
      NULL,
      NULL,
      NULL,
      1,
      3.684426,
      1.831872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697742,
      NULL,
      3,
      3.702024,
      1,
      1.782070,
      1,
      2,
      1.410878,
      2,
      0.021095,
      NULL,
      0,
      1.960280,
      0.183682,
      1,
      0.534885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.773151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685708,
      NULL,
      NULL,
      NULL,
      NULL,
      2.184924,
      1.517802,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      5.273168,
      '21331',
      NULL,
      '',
      3,
      '31031',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      1,
      1.736576,
      NULL,
      2,
      5,
      0,
      1.193304,
      3.297668);
commit;
end;
/


