set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9933372';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4431',
      '33301144',
      NULL,
      68,
      '1301312',
      NULL,
      NULL,
      1.548452,
      1,
      '320343',
      1,
      ' 5-27-1979',
      38.209779,
      53,
      1.260818,
      NULL,
      0,
      1.992119,
      2.052533,
      0,
      0,
      0,
      NULL,
      0,
      0.043653,
      0.748400,
      3,
      0.680914,
      0,
      2,
      2.771790,
      3.072120,
      1.367509,
      NULL,
      NULL,
      0,
      0.649576,
      0.840261,
      5.942333,
      1,
      4,
      2.640098,
      1.933002,
      NULL,
      NULL,
      NULL,
      1.557257,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740995,
      0,
      3,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.859727,
      2,
      3,
      0,
      2.296166,
      0.582546,
      4.957072,
      0,
      1.774485,
      1.973093,
      0,
      0,
      0.424893,
      3.654138,
      0.884549,
      1.407619,
      0,
      0,
      1.737403,
      NULL,
      1.822768,
      4.734321,
      1,
      NULL,
      1,
      NULL,
      4.522443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887494,
      4,
      NULL,
      3,
      4.837921,
      6,
      NULL,
      3.805478,
      2,
      9,
      5,
      1.571562,
      4.471496,
      1.276028,
      0,
      0,
      NULL,
      2.587697,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.932986,
      0,
      0,
      0.518961,
      NULL,
      1.595969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      NULL,
      1.474126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.072346,
      0.229308,
      NULL,
      NULL,
      NULL,
      0.758930,
      0.597273,
      1.953932,
      0,
      3.488215,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.892679,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0.185817,
      NULL,
      2,
      0.964507,
      1.248504,
      1,
      2.292877,
      1,
      0.750112,
      1,
      0.521426,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.055913,
      '24131',
      '42221',
      '',
      0,
      '43134',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      4.309134,
      1.551374,
      NULL,
      2.835144,
      2.742657,
      0,
      1.143343,
      1.587158,
      2.703108);
commit;
end;
/


