set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437107';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '422',
      '03312002',
      54.649005,
      NULL,
      '0203124',
      112.668911,
      5,
      0,
      2,
      '103313',
      5.235587,
      ' 8-21-1986',
      57.434262,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1.568516,
      NULL,
      0,
      0.351293,
      3.607093,
      1,
      1.453265,
      0.839398,
      0.828531,
      0.465748,
      1,
      0.934334,
      NULL,
      NULL,
      1.265808,
      1,
      0.198319,
      1.394630,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640519,
      0.196243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.842906,
      1.778169,
      0.812301,
      1,
      1.930293,
      0.352455,
      0,
      1.889149,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1.704845,
      0,
      0,
      NULL,
      NULL,
      0.055524,
      1.916839,
      0,
      NULL,
      0.028922,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.761775,
      NULL,
      0.940729,
      0.862940,
      0,
      1,
      NULL,
      NULL,
      5.835980,
      4.133335,
      NULL,
      1,
      0.611776,
      1.137114,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840142,
      0,
      NULL,
      1,
      0.613884,
      0,
      0.849893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790946,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.251272,
      0.640541,
      1.653684,
      0.919878,
      2,
      3.283510,
      3,
      1.055123,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.872084,
      1.905794,
      1.121013,
      NULL,
      1.740473,
      NULL,
      NULL,
      NULL,
      1.070048,
      0.343252,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.605612,
      1.323613,
      1,
      0,
      0,
      0,
      NULL,
      0.000130,
      0,
      1.098260,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0.242420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      NULL,
      0.642258,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      5.936358,
      0,
      1,
      5.501008,
      0,
      0.208955,
      NULL,
      1,
      NULL);
commit;
end;
/


