set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437107';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4024',
      '24200130',
      86.273378,
      40,
      '0033413',
      205.731072,
      NULL,
      2.848048,
      NULL,
      '232302',
      1.296674,
      ' 3-29-1984',
      NULL,
      NULL,
      1.580553,
      NULL,
      1.920689,
      NULL,
      1,
      1,
      1,
      1.011822,
      1.655682,
      1.069022,
      1,
      0.202544,
      NULL,
      1.384824,
      NULL,
      1,
      1.217075,
      0.514953,
      0,
      0,
      NULL,
      0.909855,
      0,
      NULL,
      1.998981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.739874,
      0.182771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106853,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746129,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1.959186,
      1.170388,
      1.520891,
      0,
      1.416555,
      NULL,
      0.295202,
      NULL,
      1.635269,
      1,
      0.843411,
      0.358704,
      1.096777,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801594,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      3,
      2.576255,
      2,
      1.783354,
      5.297018,
      3.124519,
      0.911350,
      NULL,
      0,
      1.234572,
      NULL,
      NULL,
      2.356010,
      1.977298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.854747,
      0,
      0,
      1,
      1,
      0,
      0.122539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331785,
      NULL,
      NULL,
      NULL,
      NULL,
      3.413706,
      1,
      2.242918,
      1.412929,
      0.225855,
      3,
      7,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.565053,
      1,
      2.628045,
      1,
      1.763606,
      1,
      1.349207,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338740,
      0.341962,
      0.025556,
      1.706246,
      1.556882,
      NULL,
      1,
      0.450735,
      1,
      0.576760,
      1.143003,
      NULL,
      1.381979,
      0,
      1.882198,
      NULL,
      0.217111,
      1,
      0,
      0.837872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.576549,
      '24402',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      5.116240,
      NULL,
      0.957009,
      3,
      2,
      3.300344,
      2,
      3,
      3.701924);
commit;
end;
/


