set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11',
      18.869907,
      6.356944,
      '3304404',
      85.710784,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 5-10-1981',
      39,
      23.376323,
      1.522090,
      NULL,
      1.503145,
      3.102100,
      0.554924,
      1,
      0.453863,
      1,
      1,
      1.821515,
      NULL,
      0,
      5,
      NULL,
      0.356164,
      1,
      1,
      NULL,
      0.336953,
      NULL,
      1.158409,
      NULL,
      1.126851,
      0.102594,
      4,
      1,
      1,
      0.321223,
      0.716001,
      NULL,
      NULL,
      NULL,
      0.946661,
      NULL,
      NULL,
      0.947439,
      1.495407,
      0.698644,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814311,
      NULL,
      0,
      0.690421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131360,
      0.665165,
      1.831708,
      0.511520,
      1.303245,
      NULL,
      2.132248,
      NULL,
      0.438081,
      0.905416,
      0.308976,
      1.668878,
      1.202961,
      2.391808,
      0.607794,
      0,
      1.256579,
      0.698461,
      NULL,
      NULL,
      0,
      3,
      1,
      2.198091,
      1.041760,
      0,
      5,
      NULL,
      2.005552,
      1.495438,
      2.219451,
      NULL,
      0,
      0.469377,
      3.266306,
      NULL,
      1,
      NULL,
      3.238067,
      5,
      4,
      NULL,
      4,
      2.223503,
      8,
      3,
      3.590773,
      3.376260,
      NULL,
      NULL,
      NULL,
      1.818207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249095,
      0.219708,
      NULL,
      NULL,
      0.925459,
      0.919184,
      0.862483,
      0.446470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.915232,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5.099768,
      5,
      NULL,
      5.636025,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.700118,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.186792,
      1,
      0.892090,
      0,
      3,
      0.215592,
      NULL,
      1.936355,
      NULL,
      3.920276,
      0,
      0,
      1,
      0.559350,
      1.930807,
      0.178522,
      NULL,
      1.243438,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.990064,
      '43102',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      0.175092,
      '',
      '',
      '',
      1.840143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


