set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '212',
      '03',
      4.348997,
      21,
      NULL,
      2.364730,
      2,
      0.518239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      NULL,
      NULL,
      0.206129,
      0,
      NULL,
      1,
      1.651151,
      NULL,
      0.586433,
      0,
      0.859361,
      3,
      1.409984,
      0.846144,
      0.385337,
      2,
      1.487085,
      0,
      1,
      4,
      1.537212,
      NULL,
      0.529367,
      3,
      1,
      1,
      1,
      2,
      0.574741,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.122481,
      0.595922,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250821,
      3,
      0.646534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.670323,
      1.102698,
      0.849713,
      NULL,
      1.155990,
      0.608211,
      0.861240,
      1.051352,
      0.819392,
      NULL,
      0.610087,
      0.595658,
      1,
      NULL,
      NULL,
      NULL,
      1.429705,
      1.316945,
      NULL,
      0.891697,
      0.730163,
      0.202958,
      2.696403,
      0.907007,
      1.205303,
      0.106095,
      0.849319,
      1.880709,
      0,
      0,
      0,
      1.455016,
      2.249403,
      1.089406,
      1,
      0.367872,
      2,
      5.634735,
      NULL,
      NULL,
      NULL,
      1.777119,
      7,
      8.922941,
      0,
      1.742888,
      0.854476,
      1.240415,
      NULL,
      NULL,
      4.309881,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998943,
      1.164316,
      0,
      NULL,
      NULL,
      NULL,
      1.503891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.389952,
      0,
      1.226120,
      NULL,
      NULL,
      NULL,
      0.758703,
      2.325508,
      4.953747,
      5,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514452,
      NULL,
      3,
      0.454961,
      2.377095,
      2,
      0.100217,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.026216,
      1,
      NULL,
      1.335782,
      0,
      0.068168,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.149802,
      '01432',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


