set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '43',
      19,
      31,
      '2344014',
      80,
      6,
      1,
      NULL,
      '124442',
      NULL,
      ' 1-19-1978',
      NULL,
      1,
      0.446618,
      NULL,
      1.812156,
      1,
      1.233171,
      1,
      NULL,
      NULL,
      2.134856,
      1.010154,
      1.209934,
      0,
      3.277860,
      1.759725,
      2.840530,
      1,
      NULL,
      0,
      4.910528,
      NULL,
      0.619209,
      0,
      1.346170,
      0,
      5,
      1,
      NULL,
      2.697848,
      2,
      0,
      NULL,
      NULL,
      0.143823,
      4,
      1.224823,
      0.235140,
      0,
      0,
      0.268449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434573,
      1.960226,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1.130780,
      0.866941,
      NULL,
      0,
      0.707244,
      NULL,
      0,
      0,
      0.483475,
      0,
      1.827530,
      1,
      1,
      NULL,
      NULL,
      0,
      3.793619,
      3,
      3,
      0.157392,
      0,
      0.294622,
      NULL,
      NULL,
      1.919262,
      4,
      2.490813,
      1.209801,
      3,
      2.668285,
      1.167675,
      NULL,
      0.069426,
      NULL,
      9.459072,
      8,
      5.406098,
      8.789927,
      1.564918,
      0,
      6,
      3.506191,
      1,
      1,
      0.212357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958201,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.763393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.377912,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.210289,
      1,
      NULL,
      3,
      2,
      2,
      2,
      NULL,
      NULL,
      NULL,
      3.733212,
      3,
      1.702151,
      3,
      NULL,
      0,
      3.229852,
      0,
      1.629137,
      1.309451,
      2.532819,
      0,
      NULL,
      2.598046,
      0.215404,
      0.610289,
      1.390019,
      NULL,
      0.514392,
      NULL,
      1.750062,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '04404',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.770842,
      '',
      '',
      '',
      1,
      NULL,
      3.213886,
      2.447088,
      1.324756,
      3.424565,
      3.689579,
      NULL,
      1);
commit;
end;
/


