set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '122',
      '14322414',
      8,
      36.874126,
      '4004324',
      178,
      NULL,
      0,
      NULL,
      '010233',
      4,
      ' 1- 9-1979',
      58.461086,
      30.369839,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1.041872,
      NULL,
      2.192518,
      1.668696,
      0,
      0.407511,
      9,
      0.104011,
      4,
      NULL,
      0.595536,
      0.601450,
      9,
      NULL,
      7,
      NULL,
      1.544315,
      1.747915,
      NULL,
      0,
      1.433532,
      NULL,
      1.256253,
      NULL,
      NULL,
      NULL,
      1,
      3.720517,
      0.845679,
      0.903188,
      NULL,
      NULL,
      0.617686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671898,
      0.083084,
      0.274894,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.628565,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.831660,
      NULL,
      1.899899,
      NULL,
      1,
      1,
      NULL,
      1.681963,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      4.594308,
      NULL,
      0.958894,
      NULL,
      NULL,
      1.471847,
      0,
      4.391139,
      NULL,
      3.670442,
      3.968660,
      0,
      0,
      0,
      0.531473,
      6.853261,
      7.208060,
      NULL,
      0.156544,
      NULL,
      3,
      2,
      11,
      NULL,
      NULL,
      NULL,
      4.713879,
      1,
      NULL,
      0.985019,
      2.306098,
      0.042052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571756,
      0,
      2,
      0,
      NULL,
      0.856733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.668821,
      NULL,
      1,
      2,
      1.936594,
      0.933067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.749959,
      0.336992,
      NULL,
      NULL,
      NULL,
      NULL,
      0.561601,
      4.460081,
      5,
      6,
      1,
      7,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.788492,
      2,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      2.813109,
      3,
      0,
      NULL,
      0.431225,
      3.523301,
      2.432000,
      0.437631,
      3,
      0.442501,
      0.422329,
      0.945037,
      1.574632,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237632,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.824998,
      '33322',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.829781,
      '',
      '',
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      2.125673,
      0,
      2.376273,
      NULL);
commit;
end;
/


