set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10321423',
      5,
      73,
      NULL,
      69,
      5,
      0,
      3,
      '334412',
      4,
      NULL,
      34,
      19.661734,
      1.529832,
      NULL,
      0,
      NULL,
      0,
      1,
      0.600799,
      0.377404,
      2.131416,
      2,
      NULL,
      NULL,
      9.137223,
      0.959292,
      2.749331,
      2,
      1.404643,
      0,
      4,
      NULL,
      4,
      0,
      0.015445,
      1,
      4.460877,
      1,
      1.716301,
      3,
      1,
      0.866511,
      NULL,
      NULL,
      1.558357,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.836678,
      0,
      1.061365,
      NULL,
      1,
      NULL,
      NULL,
      0.435314,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1.222805,
      NULL,
      NULL,
      0.221841,
      5,
      0.559074,
      NULL,
      0,
      5.278325,
      3.115209,
      0,
      5.542728,
      4.898797,
      NULL,
      6,
      3.703756,
      5,
      NULL,
      0,
      4,
      NULL,
      9,
      2.540728,
      4,
      0,
      NULL,
      NULL,
      2.850219,
      0.178266,
      0,
      0,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961076,
      0.570189,
      1,
      0,
      0.049810,
      NULL,
      0.350031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.710350,
      3,
      1.628997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.007623,
      2.777386,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569740,
      0,
      8.856232,
      1.182133,
      7,
      NULL,
      4.913212,
      NULL,
      NULL,
      NULL,
      0,
      8,
      1.734125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      0,
      0.050664,
      2.894738,
      1.082929,
      1.038681,
      NULL,
      1.171504,
      NULL,
      1,
      NULL,
      0,
      0,
      1.583896,
      NULL,
      1,
      0.567516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '33223',
      '',
      '',
      0.286696,
      '',
      '',
      '',
      1.043148,
      '',
      NULL,
      '',
      0.062863,
      5,
      3.001729,
      7.667029,
      2.628238,
      3,
      3.891609,
      2,
      3);
commit;
end;
/


